map_octree.tests.register("batch planner: volume and coverage", function()
	local function assert_true(cond, msg)
		if not cond then error(msg or "assert failed") end
	end

	local minp = vector.new(0, 0, 0)
	local maxp = vector.new(64 * 4, 64 * 3, 64 * 2)

	local small_limit = (octchunk.SIZE + 1) ^ 3 * 2
	local plan = octmap.plan_batches(minp, maxp, {
		max_voxelmanip_volume = small_limit,
		force_batches = true,
	})

	assert_true(#plan.batches > 1, "expected multiple batches")
	for _, b in ipairs(plan.batches) do
		assert_true(
			b.volume <= plan.max_voxelmanip_volume,
			string.format("batch volume %d exceeds limit %d", b.volume, plan.max_voxelmanip_volume)
		)
	end

	local size = plan.size
	local covered = {}
	for x = 1, size.x do
		covered[x] = {}
		for y = 1, size.y do
			covered[x][y] = {}
		end
	end

	for _, b in ipairs(plan.batches) do
		for x = b.x_idx, b.x_end do
			for y = b.y_idx, b.y_end do
				for z = b.z_idx, b.z_end do
					if covered[x][y][z] then
						error(string.format("overlap at %d,%d,%d", x, y, z))
					end
					covered[x][y][z] = true
				end
			end
		end
	end

	for x = 1, size.x do
		for y = 1, size.y do
			for z = 1, size.z do
				assert_true(covered[x][y][z], string.format("gap at %d,%d,%d", x, y, z))
			end
		end
	end
end)
