local tutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

map_octree.tests.register("param2: snapshot stores + queries correctly", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local center = tutil.get_test_region(ctx.player)

	local c_stone = core.get_content_id("default:stone")
	local S = octchunk.SIZE
	local half = S / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	tutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		-- Fill cube with stone
		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					data[area:index(x, y, z)] = c_stone
				end
			end
		end

		-- Param2 pattern: only a few nodes have non-zero param2
		for i = 1, #param2_data do
			param2_data[i] = 0
		end
		local samples = {
			{pos = {x = pmin.x, y = pmin.y, z = pmin.z}, p2 = 1},
			{pos = {x = pmin.x + 1, y = pmin.y, z = pmin.z}, p2 = 7},
			{pos = {x = pmin.x, y = pmin.y + 1, z = pmin.z}, p2 = 13},
			{pos = {x = pmax.x, y = pmax.y, z = pmax.z}, p2 = 42},
		}
		for _, s in ipairs(samples) do
			param2_data[area:index(s.pos.x, s.pos.y, s.pos.z)] = s.p2
		end

		manip:set_data(data)
		manip:set_param2_data(param2_data)
		manip:write_to_map(false)

		local map = octmap.new(center, center, {
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
			force_batches = true,
		})

		-- Point queries
		for _, s in ipairs(samples) do
			local name, got_p2 = map:get_node_at(s.pos.x, s.pos.y, s.pos.z)
			if name ~= "default:stone" then
				error(string.format("name mismatch at %s: expected stone, got %s", core.pos_to_string(s.pos), tostring(name)))
			end
			if got_p2 ~= s.p2 then
				error(string.format("param2 mismatch at %s: expected %d, got %d", core.pos_to_string(s.pos), s.p2, got_p2))
			end
		end

		-- Default behavior: when param2 is not stored, it reads as 0.
		local check_default = {x = pmin.x + 2, y = pmin.y + 2, z = pmin.z + 2}
		local _, got_default_p2 = map:get_node_at(check_default.x, check_default.y, check_default.z)
		if got_default_p2 ~= 0 then
			error(string.format("param2 default mismatch at %s: expected 0, got %d", core.pos_to_string(check_default), got_default_p2))
		end
	end)
end)