local rt = map_octree.restore_tracking
local MAPBLOCK_SIZE = rt.MAPBLOCK_SIZE



---@param tracker RestoreTracker
---@param gx integer
---@param gy integer
---@param gz integer
function rt.write_chunk_to_world(tracker, gx, gy, gz)
	local map = tracker.map
	local node_min = rt.grid_to_node_min(tracker, gx, gy, gz)
	local node_max = {
		x = node_min.x + MAPBLOCK_SIZE - 1,
		y = node_min.y + MAPBLOCK_SIZE - 1,
		z = node_min.z + MAPBLOCK_SIZE - 1,
	}
	local req_min = tracker.req_min or node_min
	local req_max = tracker.req_max or node_max
	local clip_min = {
		x = math.max(node_min.x, req_min.x),
		y = math.max(node_min.y, req_min.y),
		z = math.max(node_min.z, req_min.z),
	}
	local clip_max = {
		x = math.min(node_max.x, req_max.x),
		y = math.min(node_max.y, req_max.y),
		z = math.min(node_max.z, req_max.z),
	}
	if clip_min.x > clip_max.x or clip_min.y > clip_max.y or clip_min.z > clip_max.z then
		return
	end

	core.load_area(node_min, node_max)
	local manip = core.get_voxel_manip()
	local e1, e2 = manip:read_from_map(node_min, node_max)
	local area = VoxelArea(e1, e2)

	local default_cid = core.get_content_id(map.default_node or "air")
	local data = manip:get_data()
	local p2 = manip:get_param2_data()
	local p1 = manip:get_light_data()
	---@cast data integer[]
	---@cast p2 integer[]
	---@cast p1 integer[]

	local cell = matrix3d.get(map.trees, gx, gy, gz)
	if cell ~= nil then
		local tree = assert(octmap._get_tree_cached(map, gx, gy, gz))
		---@cast tree Octchunk
		local half = octchunk.SIZE / 2
		local center = vector.new(node_min.x + half, node_min.y + half, node_min.z + half)
		octchunk.fill_voxel_area(tree, clip_min, clip_max, area, data, p2, p1, nil, center, octchunk.SIZE)
	else
		for z = clip_min.z, clip_max.z do
			for y = clip_min.y, clip_max.y do
				for x = clip_min.x, clip_max.x do
					local idx = area:index(x, y, z)
					data[idx] = default_cid
					p2[idx] = 0
					p1[idx] = 0
				end
			end
		end
	end

	manip:set_data(data)
	manip:set_param2_data(p2)
	manip:set_light_data(p1)
	manip:write_to_map(true)
end
