local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field

local function get_chunk_bounds(center)
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})
	return pmin, pmax
end


map_octree.tests.register("map api: size/read_ranges/for_each_chunk_range", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local base = testutil.get_test_region(ctx.player)
	local center = octchunk.snap_to_center(vector.add(base, {x = 0, y = 0, z = 9728}))
	local pmin, pmax = get_chunk_bounds(center)

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		local cid_air = core.get_content_id("air")
		local cid_stone = core.get_content_id("default:stone")
		assert(type(cid_air) == "number", "missing node: air")
		assert(type(cid_stone) == "number", "missing node: default:stone")

		for z = pmin.z, pmax.z do
			for y = pmin.y, pmax.y do
				for x = pmin.x, pmax.x do
					local idx = area:index(x, y, z)
					data[idx] = cid_air
					if param2_data then param2_data[idx] = 0 end
				end
			end
		end
		data[area:index(center.x, center.y, center.z)] = cid_stone
		if param2_data then
			param2_data[area:index(center.x, center.y, center.z)] = 7
		end

		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		local map = octmap.new(pmin, pmax, {
			store_chunk_blobs = true,
			cache_mb = 4,
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		})

		local e1, e2 = map:get_emerged_area()
		assert(e1 and e2, "map:get_emerged_area failed")
		local size = map:size()
		assert(size, "map:size failed")
		assert(size.x == (e2.x - e1.x + 1), "map:size x mismatch")
		assert(size.y == (e2.y - e1.y + 1), "map:size y mismatch")
		assert(size.z == (e2.z - e1.z + 1), "map:size z mismatch")

		local expected_nodes = octchunk.SIZE ^ 3
		local count_node = map:read_ranges({{pos1 = e1, pos2 = e2}}, function() end)
		assert(count_node == expected_nodes, "map:read_ranges node-grid count mismatch")

		local ranges = {
			{min = {x = 1, y = 1, z = 1}, max = {x = 1, y = 1, z = 1}},
			{min = {x = 1, y = 1, z = 1}, max = {x = 1, y = 1, z = 1}},
		}

		local count_dedup = map:read_ranges(ranges, function() end, {grid = "chunk", dedup = true})
		assert(count_dedup == expected_nodes, "map:read_ranges dedup count mismatch")

		local count_nodedup = map:read_ranges(ranges, function() end, {grid = "chunk", dedup = false})
		assert(count_nodedup == expected_nodes * 2, "map:read_ranges non-dedup count mismatch")

		local chunk_count = map:for_each_chunk_range(ranges, function() end, {grid = "chunk", dedup = true})
		assert(chunk_count == 1, "map:for_each_chunk_range dedup count mismatch")

		local chunk_count2 = map:for_each_chunk_range(ranges, function() end, {grid = "chunk", dedup = false})
		assert(chunk_count2 == 2, "map:for_each_chunk_range non-dedup count mismatch")
	end)
end)