map_octree.tests.register("async save: budget-based scheduling kicks batches up to budget", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local pos = vector.round(ctx.player:get_pos())
	assert(pos and type(pos.x) == "number" and type(pos.y) == "number" and type(pos.z) == "number", "player pos required")
	local base_center = octchunk.snap_to_center(pos)
	local S = octchunk.SIZE
	local max_center = vector.add(base_center, {x = S, y = S, z = 0})

	-- Force many small batches (about 1 tree per batch)
	local size_nodes = S + 1
	local limit_one_tree = (size_nodes * size_nodes * size_nodes) + 1024

	local test_id = "async_schedule_" .. os.time()
	local async_calls = 0

	local orig_handle_async = core.handle_async

	local function restore()
		---@diagnostic disable-next-line: duplicate-set-field
		core["handle_async"] = orig_handle_async
	end

	local ok, err = pcall(function()
		---@diagnostic disable-next-line: duplicate-set-field
		core["handle_async"] = function(...)
			async_calls = async_calls + 1
			return orig_handle_async(...)
		end

		-- Budget=0 forces exactly 1 batch per tick (budget exhausted immediately)
		local plan = map_octree.save_to_file_async(base_center, max_center, {
			file_name = test_id,
			subdir = "tests",
			max_voxelmanip_volume = limit_one_tree,
			async_inflight = 4,
			read_budget_ms = 0,
		}, function()
			-- Intentionally empty: this test only asserts scheduling behavior.
		end)

		assert(plan and plan.batches, "expected save_to_file_async to return a plan with batches")
		assert(#plan.batches >= 2, "expected a multi-batch plan for scheduling test")

		-- With budget=0, initial tick should kick off exactly 1 batch
		assert(async_calls == 1, string.format(
			"expected 1 core.handle_async with budget=0, got %d (batches=%d)",
			async_calls, #plan.batches
		))

		core.log("action", string.format(
			"[test] %s: PASS (initial_async=%d, batches=%d, budget=0)",
			test_id, async_calls, #plan.batches
		))
	end)

	restore()
	if not ok then
		error(err)
	end
end)