local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field

local function get_chunk_bounds(center)
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})
	return pmin, pmax
end


map_octree.tests.register("OctreeManip: read_from_map_async", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	if map_octree.tests.async_should_skip and map_octree.tests.async_should_skip("read_from_map_async") then
		return
	end

	local base = testutil.get_test_region(ctx.player)
	local center = octchunk.snap_to_center(vector.add(base, {x = 0, y = 0, z = 9920}))
	local pmin, pmax = get_chunk_bounds(center)

	local cid_air = core.get_content_id("air")
	local cid_stone = core.get_content_id("default:stone")
	assert(type(cid_air) == "number", "missing node: air")
	assert(type(cid_stone) == "number", "missing node: default:stone")

	local test_id = "read_from_map_async_" .. os.time()
	local end_async = nil
	if map_octree.tests.async_start then
		end_async = map_octree.tests.async_start(test_id)
	end

	testutil.with_voxel_region_async(pmin, pmax, function(manip, area, data, param2_data, restore)
		for z = pmin.z, pmax.z do
			for y = pmin.y, pmax.y do
				for x = pmin.x, pmax.x do
					local idx = area:index(x, y, z)
					data[idx] = cid_air
					if param2_data then param2_data[idx] = 0 end
				end
			end
		end
		data[area:index(center.x, center.y, center.z)] = cid_stone
		if param2_data then param2_data[area:index(center.x, center.y, center.z)] = 2 end

		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map_async(pmin, pmax, function(ok, err)
			if not ok then
				core.log("error", "[test] " .. test_id .. ": read_from_map_async failed: " .. tostring(err))
				if end_async then end_async() end
				restore()
				return
			end
			local name, p2 = m:get_node_at(center.x, center.y, center.z)
			if name ~= "default:stone" or (p2 or 0) ~= 2 then
				core.log("error", "[test] " .. test_id .. ": read_from_map_async data mismatch")
				if end_async then end_async() end
				restore()
				return
			end

			if end_async then end_async() end
			restore()
		end)
	end)
end)