map_octree.tests.register("serialization migration v1->v2", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local base = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua").get_test_region(ctx.player)
	local center = octchunk.snap_to_center(base)
	local half = octchunk.SIZE / 2
	local req_min = vector.subtract(center, {x = half, y = half, z = half})
	local req_max = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	local map = octmap.new(req_min, req_max, {
		store_chunk_blobs = true,
		force_batches = true,
		max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
	})

	local size = map.trees.size
	local out = {
		requested_pos1 = nil,
		requested_pos2 = nil,
		minp = map.minp,
		maxp = map.maxp,
		default_node = map.default_node,
		content_id_map = map.content_id_map,
		trees = matrix3d.new(size.x, size.y, size.z, nil),
	}

	matrix3d.iterate(map.trees, function(x, y, z)
		local tree = matrix3d.get(map.trees, x, y, z)
		if tree == nil then
			return
		elseif type(tree) == "string" then
			matrix3d.set(out.trees, x, y, z, tree)
		else
			matrix3d.set(out.trees, x, y, z, octchunk.serialize(tree))
		end
	end)

	local raw = core.serialize(out)
	---@diagnostic disable-next-line: param-type-mismatch
	local compressed = core.compress(raw, "zstd", 9)
	local data = "MOTM" .. string.char(1) .. compressed

	local loaded, err = octmap.deserialize(data)
	assert(loaded, err or "deserialize failed")

	local l1, l2 = loaded:get_emerged_area()
	assert(l1 and l2, "expected emerged area")
	---@cast l1 vector
	---@cast l2 vector
	assert(l1.x == req_min.x and l1.y == req_min.y and l1.z == req_min.z, "migrated min not exact")
	assert(l2.x == req_max.x and l2.y == req_max.y and l2.z == req_max.z, "migrated max not exact")
end)
