local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")


map_octree.tests.register("place exact bounds (sync)", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local base = testutil.get_test_region(ctx.player)
	local center = octchunk.snap_to_center(base)
	local half = octchunk.SIZE / 2
	local chunk_min = vector.subtract(center, {x = half, y = half, z = half})
	local chunk_max = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	local req_min = vector.add(chunk_min, {x = 2, y = 2, z = 2})
	local req_max = vector.add(chunk_min, {x = 5, y = 5, z = 5})

	local stone = core.get_content_id("default:stone")
	local sand = core.get_content_id("default:sand")

	local file_name = "exact_bounds_place_sync_" .. os.time()
	local subdir = "tests"

	testutil.with_voxel_region(chunk_min, chunk_max, function(manip, area, data)
		testutil.fill_region(area, data, chunk_min, chunk_max, function()
			return stone
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		testutil.fill_region(area, data, req_min, req_max, function()
			return sand
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		local map, err = map_octree.save_to_file(req_min, req_max, {
			file_name = file_name,
			subdir = subdir,
			store_chunk_blobs = true,
			force_batches = true,
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		})
		assert(map, err or "save_to_file failed")

		testutil.fill_region(area, data, chunk_min, chunk_max, function()
			return stone
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		assert(map_octree.place(map, req_min), "place failed")

		local inside = core.get_content_id(core.get_node(req_min).name)
		local outside_pos = vector.subtract(req_min, {x = 1, y = 0, z = 0})
		local outside = core.get_content_id(core.get_node(outside_pos).name)
		assert(inside == sand, "inside bounds should be sand")
		assert(outside == stone, "outside bounds should remain stone")
	end)

	local dir = map_octree.get_storage_dir(subdir)
	os.remove(dir .. "/" .. file_name .. ".bin")
end)


map_octree.tests.register("place exact bounds (async)", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	if map_octree.tests.async_should_skip and map_octree.tests.async_should_skip("place_exact_bounds_async") then
		return
	end

	local base = testutil.get_test_region(ctx.player)
	local center = octchunk.snap_to_center(base)
	local half = octchunk.SIZE / 2
	local chunk_min = vector.subtract(center, {x = half, y = half, z = half})
	local chunk_max = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	local req_min = vector.add(chunk_min, {x = 2, y = 2, z = 2})
	local req_max = vector.add(chunk_min, {x = 5, y = 5, z = 5})

	local stone = core.get_content_id("default:stone")
	local sand = core.get_content_id("default:sand")

	local file_name = "exact_bounds_place_async_" .. os.time()
	local subdir = "tests"
	local end_async = map_octree.tests.async_start("place_exact_bounds_async_" .. os.time())

	testutil.with_voxel_region_async(chunk_min, chunk_max, function(manip, area, data, _, restore)
		testutil.fill_region(area, data, chunk_min, chunk_max, function()
			return stone
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		testutil.fill_region(area, data, req_min, req_max, function()
			return sand
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		local map, err = map_octree.save_to_file(req_min, req_max, {
			file_name = file_name,
			subdir = subdir,
			store_chunk_blobs = true,
			force_batches = true,
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		})
		assert(map, err or "save_to_file failed")

		testutil.fill_region(area, data, chunk_min, chunk_max, function()
			return stone
		end)
		manip:set_data(data)
		manip:write_to_map(false)

		map_octree.place_async(map, req_min, {min_delay = 0}, function(ok, err2)
			local ok_restore = ok == true
			if not ok_restore then
				restore()
				end_async()
				assert(ok, "place_async failed: " .. tostring(err2))
				return
			end

			local inside = core.get_content_id(core.get_node(req_min).name)
			local outside_pos = vector.subtract(req_min, {x = 1, y = 0, z = 0})
			local outside = core.get_content_id(core.get_node(outside_pos).name)
			restore()

			local dir = map_octree.get_storage_dir(subdir)
			os.remove(dir .. "/" .. file_name .. ".bin")

			end_async()
			assert(inside == sand, "inside bounds should be sand")
			assert(outside == stone, "outside bounds should remain stone")
		end)
	end)
end)
