map_octree.tests.register("octcache: trim after release", function()
	octcache.delete()
	local node = {
		[octchunk.ID] = 1,
		[octchunk.CHILDREN] = {
			[1] = {[octchunk.ID] = 2},
		}
	}

	octcache.create(node)
	octcache.use(node)
	octcache.use(node)

	local stats_before = octcache.get_stats()
	assert(stats_before.hashes >= 1, "expected hash refs before release")

	octcache.release(node)
	octcache.trim()

	local stats_after = octcache.get_stats()
	assert(stats_after.hashes < stats_before.hashes, "expected hash refs to decrease after release+trim")
	octcache.delete()
end)