local S = minetest.get_translator("murder")


weapons_lib.register_weapon("murder:gun", {
    description = S("Shoot and kill!"),
    on_drop = function() return end,
    inventory_image = "item_murder_gun.png",
    wield_image = "item_murder_gun.png",
    range = 0,
    magazine = 3,
    groups = {murder = 1},
    stack_max = 1,
    weapon_type = "ranged",
    reload_time = 3,
    sound_reload = "murder_gun_reload",
    crosshair = "murder_crosshair_gun.png",
    slow_down_user = true,

    action1 = {
        type = "raycast",
        damage = 0,
        delay = 0.25,
        range = 100,
        trail = {
            image = "blank.png",
        },

        on_use = function(player, weap_def, action)
            local particle_shot = {
                pos = vector.add(player:get_pos(), vector.new(0, 1.5, 0)),
                velocity = vector.multiply(player:get_look_dir(), 70),
                size = 1,
                texture = "particle_murder_shoot.png",
                glow = 12,
                playername = player:get_player_name()
            }

            core.add_particle(particle_shot)

            minetest.sound_play("murder_gun_shoot", {to_player = player:get_player_name()})
        end,

        on_hit = function(hitter, target, weap_def, action, hit_point, damage, knockback, proxy_obj)
            local pl_name = hitter:get_player_name()
            if not murder.is_player_playing(pl_name) then return 0, 0 end
            local arena = arena_lib.get_arena_by_player(pl_name)

            if target:is_player() then
                local hit_name = target:get_player_name()

                if target:get_hp() <= 0 then
                    return 0, 0
                elseif not murder.is_player_playing(hit_name) then
                    return 0, 0
                end

                if hit_name ~= pl_name then
                    murder.log(arena, pl_name .. " is shooting " .. hit_name)

                    local shooter_role = arena.roles[pl_name]
                    local target_role = arena.roles[hit_name]

                    if shooter_role.name == "Detective" and target_role.name == "Detective" then
                        murder.print_msg(pl_name, S("You shot an innocent, you've been fired!"))
                        murder.print_msg(hit_name, S("Phew, your bulletproof vest saved your life from a shot by another detective!"))

                        murder.eliminate_role(pl_name)

                        minetest.sound_play("murder_gun_shoot", {to_player = hit_name})
                    else
                        murder.kill_player(pl_name, hit_name)
                        minetest.sound_play("murder_gun_shoot", {to_player = hit_name})
                    end
                end
            end

            return 0, 0
        end
    }
})
