local function remove_userdata(t) end
local function keep_just_data(t) end

local storage = minetest.get_mod_storage()

--[[
    {
        "player": {
            {"mod:skill1" = {...}},
            {"mod:skill2" = {...}}
        }
    }
--]]
skills.player_skills = minetest.deserialize(storage:get_string("player_skills")) or {}



minetest.register_on_mods_loaded(function()
	skills.update_db()
end)




function skills.update_db()
	local pl_data = table.copy(skills.player_skills)
	keep_just_data(pl_data)

	-- serialize data and save it
	minetest.handle_async(function (pl_data)
		return minetest.serialize(pl_data)
	end,
	function(serialized_pl_data)
		storage:set_string("player_skills", serialized_pl_data)
		minetest.after(10, skills.update_db)
	end, pl_data)
end



function skills.remove_unregistered_skills_from_db()
	for pl_name, pl_skills in pairs(skills.player_skills) do
		for skill_name, def in pairs(pl_skills) do
			if not skills.get_skill_def(skill_name) then pl_skills[skill_name] = nil end
		end
	end
end



function remove_userdata(t)
	for key, value in pairs(t) do
		if type(value) == "table" then remove_userdata(value) end
		if minetest.is_player(value) or type(value) == "userdata" or type(value) == "function" then t[key] = nil end
	end
end



function keep_just_data(t)
	for pl_name, skills in pairs(t) do
		for name, table in pairs(skills) do
			for key, value in pairs(table) do
				if key ~= "data" then
					table[key] = nil
				else
					remove_userdata(table.data)
				end
			end
		end
	end
end