skills.settings = {}



-- CONFIGURE SETTINGS

local mod = "skills"

-- folder where the settings files will be copied into the world directory (if specified, must end with "/")
local settings_dir = ""

local original_files = {
	"SETTINGS.lua",
}

-----------------



local modpath = core.get_modpath(mod)
local world_dir = core.get_worldpath() .. ("/%s/"):format(mod)
settings_dir = world_dir .. settings_dir

core.mkdir(world_dir)    -- init world dir
core.mkdir(settings_dir) -- init settings dir



local function from_path_to_file(path)
	return string.match(path, [[([^\\\/]*.lua)]])
end



local function is_file_in_dir(dir, file)
	file = from_path_to_file(file)

	for i, file_ in ipairs(core.get_dir_list(dir, false)) do
		if file_ == file then return true end
	end
end



local function import_default(file)
	local default_file = ("%s/%s"):format(modpath, file)
	dofile(default_file)
end



local function import_custom(file)
	local default_file = ("%s/%s"):format(modpath, file)
	local custom_file = settings_dir .. from_path_to_file(file)

	if not is_file_in_dir(settings_dir, file) then
		local default_content = io.open(default_file, "r"):read("*all")
		default_content = default_content:gsub("--!([^\n]*[\n]?)", "") -- remove warning comments

		core.safe_file_write(custom_file, default_content)
	end

	dofile(custom_file)
end



for i, file in ipairs(original_files) do
	import_default(file)
	import_custom(file)
end
