mtt.register("skills_loads", {
    func = function(callback)
        assert(type(skills) == "table", "namespace skills doesn't exist")
        callback() -- ok
    end
})

mtt.register("player1_joined", {
    timeout = 20,
    func = function(callback)
        minetest.after(18, function()
            assert(core.get_player_by_name("player1"), "player1 hasn't joined")
            callback() -- ok
        end)
    end
})

-- unconventional way of doing it but the easiest for now
mtt.register("run_tests", {
    timeout = skills.tests.get_total_duration() + 2,
    func = function(callback)
        skills.tests.run("player1")
        minetest.after(skills.tests.get_total_duration() + 1, function()
            local failed, failed_msg = skills.INTERNAL_TESTS_FAILED, "Internal test suite failed"
            assert(not failed, failed_msg)
            callback()
        end
        )
    end
})
