# Testing with Docker Test Harness

This directory contains the tools necessary to run automated tests for the mod using Docker or Podman.

## Prerequisites

To run these tests locally (on Windows via WSL 2 - if you use Linux just run cmds directly), you need:

1.  **Docker Desktop**:
    *   Install Docker Desktop on Windows.
    *   Enable **WSL 2 based engine** in Settings > General.
    *   Enable **WSL Integration** for your specific distro in Settings > Resources > WSL Integration.
2.  **WSL 2 Distro** (e.g., Ubuntu):
    *   Install `jq` (required for parsing configuration):
        ```bash
        sudo apt update && sudo apt install jq -y
        ```
    *   Install `dos2unix` (to fix potential line ending issues):
        ```bash
        sudo apt install dos2unix -y
        ```

## How to Run Tests

1.  Open your WSL terminal.
2.  Navigate to the mod root directory.
3.  Ensure the script is executable:
    ```bash
    chmod +x .util/run_tests.sh
    ```
4.  Run the script from the mod root directory:
    ```bash
    ./.util/run_tests.sh
    ```