--
-- Type definitions for skill registration system
--

---@alias SkillInternalName string Skill identifier in format "prefix:skill_name"
---@alias vector {x: number, y: number, z: number}

---@class ObjectRef

---@class DynamicValue
---@field dynamic_value boolean Always true
---@field get_value fun(skill: PlayerSkill, ...: any): any Function returning the value

---@alias LoopParams {cast_rate?: number|DynamicValue, duration?: number|DynamicValue, extend_duration_on_restart?: boolean|DynamicValue}

---@class SoundSpec
---@field name string|DynamicValue Sound name
---@field to_player? boolean|string|DynamicValue If true, becomes player name
---@field object? boolean|ObjectRef|DynamicValue If true, becomes player ObjectRef
---@field exclude_player? boolean|ObjectRef|string|DynamicValue If true, excludes player (can be player name)
---@field random_pitch? number[]|DynamicValue {min, max} Random pitch range
---@field ephemeral? boolean|DynamicValue Whether sound is ephemeral
---@field volume? number|DynamicValue
---@field pitch? number|DynamicValue
---@field loop? boolean|DynamicValue
---@field max_hear_distance? number|DynamicValue
---@field pos? vector|DynamicValue Position
---@field _skill? PlayerSkill Internal reference to skill

---@alias SkillSounds {cast?: SoundSpec|SoundSpec[]|DynamicValue, start?: SoundSpec|SoundSpec[]|DynamicValue, stop?: SoundSpec|SoundSpec[]|DynamicValue, bgm?: SoundSpec|SoundSpec[]|DynamicValue}

---@alias EntityAttachment {name: string|DynamicValue, pos: vector|DynamicValue, bone?: string|DynamicValue, rotation?: vector|DynamicValue, forced_visible?: boolean|DynamicValue}

---@alias SkillAttachments {particles?: table[]|DynamicValue, entities?: EntityAttachment[]|DynamicValue}

---@alias PhysicsModifier {operation?: "add"|"sub"|"multiply"|"divide"|DynamicValue, speed?: number|DynamicValue, jump?: number|DynamicValue, gravity?: number|DynamicValue}

---@alias MonoidEffect {ref: string, value: any, branch?: string}

---@class MonoidConfig
---@field checkout_branch_while_active? boolean Auto-checkout branches when active
---@field [string] MonoidEffect Named monoid effects

---@alias MonoidData {monoid: any, branch: string}

---@alias CelestialVaultConfig {sky?: table|DynamicValue, moon?: table|DynamicValue, sun?: table|DynamicValue, stars?: table|DynamicValue, clouds?: table|DynamicValue}

---@alias BlockingConfig {mode: "all"|"whitelist"|"blacklist", allowed?: string[], blocked?: string[]}

---@class HudElement
---@field name string HUD element identifier
---@field hud_elem_type string Type (e.g., "text", "image")
---@field position vector Position on screen
---@field scale vector Scale
---@field text? string|DynamicValue Text or image

---@alias PrefixConfig {base_layers?: string[]}

---@class SkillConfig User-provided configuration for skill registration
---@field name string Display name
---@field description? string Description text
---@field cooldown? number Cooldown in seconds
---@field is_layer? boolean Whether this is a layer (not unlockable by players)
---@field is_state? boolean Whether this is a state (ephemeral, applied externally)
---@field passive? boolean Auto-start when unlocked
---@field stop_on_death? boolean Stop skill on player death (default true)
---@field data? table<string, any> Persistent player-specific data
---@field logic? function The actual cast function logic (unwrapped)
---@field can_cast? fun(self: PlayerSkill, ...: any): boolean Check if can cast now
---@field can_start? fun(self: PlayerSkill, ...: any): boolean Check if can start
---@field on_start? fun(self: PlayerSkill, ...: any): boolean Callback on start
---@field on_stop? fun(self: PlayerSkill): boolean Callback on stop
---@field loop_params? LoopParams|DynamicValue Looping configuration
---@field sounds? SkillSounds|DynamicValue Sound definitions
---@field hud? HudElement[]|DynamicValue HUD elements to display
---@field attachments? SkillAttachments|DynamicValue Particle/entity attachments
---@field physics? PhysicsModifier|DynamicValue Physics modifications
---@field monoids? MonoidConfig Monoid integration
---@field celestial_vault? CelestialVaultConfig|DynamicValue Sky/sun/moon/stars/clouds
---@field blocks_other_skills? BlockingConfig Skill blocking configuration
---@field blocks_other_states? BlockingConfig State blocking configuration

---@class RegisteredSkill : SkillConfig Complete skill definition after registration
---@field internal_name SkillInternalName Unique identifier (e.g., "mod:skill_name")
---@field cooldown_timer number Internal cooldown timer state
---@field is_active boolean Whether skill is currently active
---@field data table<string, any> Persistent player-specific data
---@field cast fun(self: PlayerSkill, ...: any): boolean Wrapped cast function
---@field start fun(self: PlayerSkill, ...: any): boolean Start skill (for looped)
---@field stop fun(self: PlayerSkill, cancelled?: boolean): boolean Stop skill
---@field add_entity fun(self: PlayerSkill, pos: vector, name: string): ObjectRef|false
---@field disable fun(self: PlayerSkill): boolean
---@field enable fun(self: PlayerSkill): boolean

---@class PlayerSkill : RegisteredSkill Player-specific skill instance
---@field pl_name string Player name
---@field player ObjectRef Player object reference
---@field __dtime number Time since last cast (seconds)
---@field __last_us_time? number Last microsecond timestamp
---@field __last_start_timestamp? number Start timestamp in microseconds
---@field __varargs? table Stored varargs from start/cast
---@field __is_stopping? boolean Whether currently stopping
---@field __hud? table<string, number> HUD element IDs {"name" = hud_id}
---@field __particles? table<number, number> Particle spawner handles
---@field __bgm? table<number, number> Background music handles
---@field __stop_job? any Scheduled stop job
---@field __cast_job? any Scheduled cast job (for looped skills)
---@field __monoids? table<string, MonoidData> Active monoid changes
---@field __sky? table Original sky parameters
---@field __moon? table Original moon parameters
---@field __sun? table Original sun parameters
---@field __stars? table Original stars parameters
---@field __clouds? table Original clouds parameters
---@field is_running fun(self: PlayerSkill): boolean Check if skill is running (active and not stopping)
