local get_player_by_name = minetest.get_player_by_name


function skywars.kill_players_out_map(arena)
    for pl_name in pairs(arena.players) do
        local player = get_player_by_name(pl_name)
        local pl_pos = player:get_pos()

        if pl_pos.y < arena.min_y then
            player:set_hp(0)
        end
    end
end



function skywars.load_mapblocks(arena)
    minetest.load_area(arena.min_pos, arena.max_pos)
    minetest.emerge_area(arena.min_pos, arena.max_pos)
end