--[[
                            ! WARNING !
Don't change the variables names if you don't know what you're doing!

(skywars_settings.variable_name = value)
]]

-- The table that stores all the global variables, don't touch this.
skywars_settings = {}



-- ARENA LIB'S SETTINGS --


--  The time between the loading state and the start of the match.
skywars_settings.loading_time = 15

-- The time between the end of the match and the respawn at the hub.
skywars_settings.celebration_time = 5

-- What's going to appear in most of the lines printed by skywars.
skywars_settings.prefix = "Skywars > "

-- The players walking speed when they're playing a match.
skywars_settings.player_speed = 1.5

-- Custom base knockback settings (applies only during skywars matches)
skywars_settings.custom_knockback_enabled = true

-- Knockback is applied as additional velocity.
-- Base knockback applied on every hit (minimum feedback)
skywars_settings.custom_kb_horizontal_base = 3.5
skywars_settings.custom_kb_vertical_base = 2.5

-- Horizontal knockback: base + damage * custom_kb_horizontal_per_damage (clamped)
skywars_settings.custom_kb_horizontal_per_damage = 2
skywars_settings.custom_kb_horizontal_max = 6

-- Vertical knockback (small hop): base + damage * custom_kb_vertical_per_damage (clamped)
skywars_settings.custom_kb_vertical_per_damage = 1
skywars_settings.custom_kb_vertical_max = 1.5

-- true = on/false = off (case sensitive).
skywars_settings.fall_damage_disabled = true




-- HUDS SETTINGS --


-- Real coordinates:
-- a unit of measurement which is roughly around 64 pixels, but
-- varies based on the screen density and scaling settings of the client.


-- The background width in real coordinates
skywars_settings.background_width = 11

-- The background height in real coordinates
skywars_settings.background_height = 11

-- The x position offset from the background border of the first buttons row
-- in real coordinates, the bigger it is the righter the row will be placed.
--[[
              1.7
       |------|--------------------> x
       |      |
	   |  * * * Background  * * *
       |  *   |                 *
       |  *   |                 *  
   6.6 ---*-- Button1 Button2   *  --> FIRST ROW
       |  *   Button3 Button4   *
       |  *                     *
       |  *                     *
       |  * * * * * * * * * * * *
       |
	   \/ y     
]]
skywars_settings.starting_x = 1.7

-- The y position offset from the background border of the first buttons row
-- in real coordinates, the bigger it is the lower the row will be placed.
skywars_settings.starting_y = 5

-- The horizontal distance between buttons in real coordinates.
skywars_settings.distance_x = 3.1

-- The vertical distance between buttons in real coordinates.
skywars_settings.distance_y = 2.8

-- The amount of buttons in a row.
skywars_settings.buttons_per_row = 3

-- The buttons width in real coordinates.
skywars_settings.buttons_width = 1.8

-- The buttons height in real coordinates.
skywars_settings.buttons_height = 1.8




-- AUTO EQUIP. SYSTEM --

skywars_settings.auto_equip_items = true

-- The items importances that are used by the auto equip system:
-- when a player takes an item from a chest, if it has a greater
-- importance and it's in the same group of the one in the hotbar,
-- the latter gets replaced. Supports "*" wildcard.
skywars_settings.items_importances = {
    pickaxe = {
        ["default:pick_wood"] = 0,
        ["default:pick_stone"] = 1,
        ["default:pick_bronze"] = 2,
        ["default:pick_steel"] = 3,
        ["default:pick_diamond"] = 4,
        ["default:pick_mese"] = 5,
    },
    sword = {
        ["default:sword_wood"] = 0,
        ["default:sword_stone"] = 1,
        ["default:sword_bronze"] = 2,
        ["default:sword_steel"] = 3,
        ["default:sword_diamond"] = 4,
        ["default:sword_mese"] = 5,
    },
    shovel = {
        ["default:shovel_wood"] = 0,
        ["default:shovel_stone"] = 1,
        ["default:shovel_bronze"] = 2,
        ["default:shovel_steel"] = 3,
        ["default:shovel_diamond"] = 4,
        ["default:shovel_mese"] = 5,
    },
    axe = {
        ["default:axe_wood"] = 0,
        ["default:axe_stone"] = 1,
        ["default:axe_bronze"] = 2,
        ["default:axe_steel"] = 3,
        ["default:axe_diamond"] = 4,
        ["default:axe_mese"] = 5,
    },
    arrows = {
        ["nextgen_bows:arrow"] = -1,
        ["enderpearl:ender_pearl"] = 0,
        ["aes_events:snowball"] = 0,
        ["default:apple"] = 0,
        ["golden_bread:golden_bread"] = 0,
        ["bucket:bucket_lava"] = 0,
        ["xdecor:cobweb"] = 0,
        ["default:sword_*"] = 0,
        ["default:pick_*"] = 0,
        ["default:axe_*"] = 0,
        ["default:shovel_*"] = 0,
    }
}




-- ARMOR 3D SETTINGS --

skywars_settings.auto_equip_armors = true

skywars_settings.remove_armors_on_join = true

-- The armors importances that are used by the auto equip system:
-- when a player takes an armor from a chest, if it has a greater
-- importance that the already equipped one, the latter gets replaced.
-- If the armor name contains one of this materials then the
-- corresponding importance will be associated with it.
skywars_settings.armors_importances = {
    ["cactus"] = 0,
    ["wood"] = 1,
    ["gold"] = 2,
    ["bronze"] = 3,
    ["steel"] = 4,
    ["mithril"] = 5,
    ["diamond"] = 6
}


-- CHEST TEMPLATE COLORS --
-- These colors are used to visually distinguish chest placeholders in the editor.
-- Each template can have a color assigned, and a placeholder node is registered for each color.
-- Format: color_key = hex_color (no spaces in color_key)
skywars_settings.chest_placeholder_colors = {
    brown = "#bf7958",      -- default/neutral
    red = "#e6482e",
    orange = "#f47e1b",
    yellow = "#f4b41b",
    lime = "#b6d53c",
    green = "#71aa34",
    teal = "#3c5956",
    cyan = "#28ccdf",
    blue = "#3978a8",
    purple = "#564064",
    magenta = "#cd6093",
    pink = "#ffaeb6",
    white = "#dff6f5",
    gray = "#7d7071",
}
