local random = math.random
local ceil = math.ceil
local table_insert = table.insert
local function treasure_to_itemstack() end


function skywars.generate_treasure_id(arena)
	local max_id = 1
	
	for i = 1, #arena.treasures do
		if arena.treasures[i].id > max_id then
			max_id = arena.treasures[i].id
		end
	end

	return max_id+1
end



function skywars.reorder_treasures(arena)
	-- Ordina i tesori dal meno raro (rarity bassa) al più raro (rarity alta)
	for j = #arena.treasures, 2, -1 do
		for i = 1, #arena.treasures-1 do
			if arena.treasures[i].rarity > arena.treasures[i+1].rarity then
				local temp = arena.treasures[i]
				arena.treasures[i] = arena.treasures[i + 1]
				arena.treasures[i + 1] = temp
			end
		end
	end
end



function skywars.select_random_treasures(chest, arena)
	local preciousness_filtered_treasures = {}
	local generated_treasures = {}
	local treasure_amount = ceil(random(chest.min_treasures, chest.max_treasures))
	local treasures = table.copy(arena.treasures)

	-- if refilled, make items <= rarity 5 +1 rarity temporarily
	-- and items > 5 become -1 rarity
	if arena.chests_refilled then
		for i = 1, #treasures do
			local treasure = treasures[i]
			if treasure.rarity <= 5 then
				treasure.rarity = treasure.rarity + 1
			else
				treasure.rarity = treasure.rarity - 1
			end
		end
	end
	
	-- Filter treasures by preciousness
	for i = 1, #treasures do
		local treasure = treasures[i]
		if treasure.preciousness >= chest.min_preciousness and treasure.preciousness <= chest.max_preciousness then
			table_insert(preciousness_filtered_treasures, treasure)
		end
	end

	if #preciousness_filtered_treasures == 0 then
		return generated_treasures -- No available treasures
	end

	-- Shuffle the filtered treasures to avoid bias in cumulative selection
	for i = #preciousness_filtered_treasures, 2, -1 do
		local j = random(1, i)
		preciousness_filtered_treasures[i], preciousness_filtered_treasures[j] = preciousness_filtered_treasures[j], preciousness_filtered_treasures[i]
	end

	-- Calculate weights for the cumulative system
	-- Now uses a quadratic scaling: weight = (11 - rarity)^2
	local weights = {}
	local total_weight = 0
	for i = 1, #preciousness_filtered_treasures do
		local treasure = preciousness_filtered_treasures[i]
		local weight = (11 - treasure.rarity) * (11 - treasure.rarity)
		weights[i] = weight
		total_weight = total_weight + weight
	end

	-- Generate treasures using the cumulative weight system
	while #generated_treasures < treasure_amount do
		if #preciousness_filtered_treasures == 0 then
			core.log("error", "[Skywars Treasures] No treasures available to fill the chest. Required: " .. treasure_amount .. ", generated: " .. #generated_treasures)
			break
		end
		local random_value = random() * total_weight
		local cumulative_weight = 0
		local selected_treasure = nil
		local selected_index = nil
		for j = 1, #preciousness_filtered_treasures do
			cumulative_weight = cumulative_weight + weights[j]
			if random_value <= cumulative_weight then
				selected_treasure = preciousness_filtered_treasures[j]
				selected_index = j
				break
			end
		end
		
		if selected_treasure then
			local treasure_itemstack = treasure_to_itemstack(selected_treasure)
			if treasure_itemstack == "error" then
				for k = 1, #preciousness_filtered_treasures do
					if preciousness_filtered_treasures[k] == selected_treasure then
						total_weight = total_weight - (weights[k] or 0)
						table.remove(preciousness_filtered_treasures, k)
						table.remove(weights, k)
						break
					end
				end
				core.log("error", "[Skywars Treasures] Removed problematic treasure: " .. (selected_treasure.name or "unknown"))
			elseif treasure_itemstack then
				table_insert(generated_treasures, treasure_itemstack)
				-- Decrease the weight of the selected item by 10%
				if selected_index then
					total_weight = total_weight - weights[selected_index]
					weights[selected_index] = weights[selected_index] * 0.9
					total_weight = total_weight + weights[selected_index]
				end
			end
		else
			core.log("error", "[Skywars Treasures] Error selecting treasure, cannot continue")
			break
		end
	end

	-- If not enough treasures were generated, fill with random treasures from the filtered list
	while #generated_treasures < treasure_amount and #preciousness_filtered_treasures > 0 do
		local random_index = random(1, #preciousness_filtered_treasures)
		local treasure_itemstack = treasure_to_itemstack(preciousness_filtered_treasures[random_index])
		if treasure_itemstack ~= "error" and treasure_itemstack then
			table_insert(generated_treasures, treasure_itemstack)
		else
			table.remove(preciousness_filtered_treasures, random_index)
		end
	end

	return generated_treasures
end



function treasure_to_itemstack(treasure)
	local itemstack = {}
	itemstack.name = treasure.name
	itemstack.count = treasure.count

	if ItemStack(itemstack):is_known() == false then
		core.log("error","[Skywars Treasures] I was asked to put "..treasure.name.." inside a chest, but it doesn't exist.")
		return "error"
	end
	return skywars.add_info_to_itemstack(ItemStack(itemstack))
end