local function compare_items(item1, item2) end
local function get_item_importances(item_name) end
local function get_first_empty_slot(list) end
local function wildcard_to_pattern(wildcard) end
local function matches_registered_item(registered_name, item_name) end
local on_punch = minetest.registered_entities["__builtin:item"].on_punch 


function skywars.auto_equip_item(player, picked_itemstack, picked_itemstack_slot)
    if not skywars_settings.auto_equip_items then return end

    local inventory = player:get_inventory()
    local hotbar = inventory:get_list("main")

    for hotbar_slot, hotbar_itemstack in ipairs(hotbar) do
        if hotbar_slot > player:hud_get_hotbar_itemcount() then
            break
        end

        local hotbar_item_name = hotbar_itemstack:get_name()

        if hotbar_item_name == "" then
            goto continue
        end

        local picked_item_name = picked_itemstack:get_name()
        local best_item_name = compare_items(hotbar_item_name, picked_item_name)

        if best_item_name == picked_item_name then
            local first_empty_slot = get_first_empty_slot(hotbar)
            if not first_empty_slot then return end  -- Returning if the inventory is full.

            -- in case it was a drop
            if picked_itemstack_slot then
                hotbar[picked_itemstack_slot] = ItemStack("")
            end
            hotbar[hotbar_slot] = picked_itemstack
            hotbar[first_empty_slot] = hotbar_itemstack
            inventory:set_list("main", hotbar)
            
            return true
        end

        ::continue::
    end
end



-- Applying the auto equip system when the player takes an item from an inventory.
minetest.register_on_player_inventory_action(function(player, action, inventory, inventory_info)
    local pl_name = player:get_player_name()

    if arena_lib.is_player_in_arena(pl_name, "skywars") then
        if action == "put" then
            local picked_itemstack = inventory_info.stack
            skywars.auto_equip_item(player, picked_itemstack, inventory_info.index)
        end
    end
end)



-- Applying the auto equip system when somenone punches on a drop.
minetest.registered_entities["__builtin:item"].on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
    local pos = self.object:get_pos()
    local pl_name = puncher:get_player_name()

    if arena_lib.is_player_in_arena(pl_name, "skywars") then
        local itemstack = ItemStack(self.itemstring)

        if skywars.auto_equip_item(puncher, itemstack) then
            self.object:remove()
            return
        end
    end

    on_punch(self, puncher, time_from_last_punch, tool_capabilities, dir)
end



function wildcard_to_pattern(wildcard)
    -- escapes Lua pattern metacharacters, then turns every "*" into ".*" to emulate a simple wildcard.
    local escaped = wildcard:gsub("([%^%$%(%)%%.%[%]%+%-%?])", "%%%1")
    return "^" .. escaped:gsub("%*", ".*") .. "$"
end



function matches_registered_item(registered_name, item_name)
    if registered_name == item_name then return true end
    if not registered_name:find("*", 1, true) then return false end

    local pattern = wildcard_to_pattern(registered_name)
    return item_name:match(pattern) ~= nil
end



function compare_items(item1, item2)
    local item1_importances = get_item_importances(item1)
    local item2_importances = get_item_importances(item2)

    if not item1_importances or not item2_importances then return end

    local best_item
    local best_diff = 0

    for category, item1_importance in pairs(item1_importances) do
        local item2_importance = item2_importances[category]
        if item2_importance then
            local diff = item2_importance - item1_importance

            if diff > best_diff then
                best_diff = diff
                best_item = item2
            elseif diff < 0 and -diff > best_diff then
                best_diff = -diff
                best_item = item1
            end
        end
    end

    return best_item
end



function get_item_importances(item_name)
    local matches

    for category, importances in pairs(skywars_settings.items_importances) do
        for registered_name, importance in pairs(importances) do
            if matches_registered_item(registered_name, item_name) then
                if not matches then matches = {} end
                local previous = matches[category]
                if not previous or importance > previous then
                    matches[category] = importance
                end
            end
        end
    end

    return matches
end



function get_first_empty_slot(list)
    for i, itemstack in ipairs(list) do
        if i > 8 and itemstack:get_name() == "" then return i end
    end
end