local function get_valid_arena() end
local function get_looking_node_pos() end
local function from_chest_to_string() end
local function from_treasure_to_string() end
local function get_wielded_item() end
local function get_texture_from_item(item_name) end

local S = skywars.T



ChatCmdBuilder.new("skywars", function(cmd)
    cmd:sub("tutorial", function(sender)
        skywars.print_msg(sender, "You can read it from TUTORIAL.txt in the mod folder.")
    end)



    cmd:sub("fast enable :arena", function(name, arena_name)
        local arena = get_valid_arena(arena_name, name)

        if not arena then return end

        arena_lib.enable_arena(name .. "@", "skywars", arena.name)
    end)



    --------------------
    -- ! CHEST CMDS ! --
    --------------------

    cmd:sub("addtreasure :arena :treasure :count:int :preciousness:int :rarity:number",
        function(sender, arena_name, treasure_name, count, preciousness, rarity)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)

            if not arena then
                return
            elseif count < 1 then
                skywars.print_error(sender, S("Count has to be greater than 0!"))
                return
            elseif rarity < 1 or rarity > 10 then
                skywars.print_error(sender, S("Rarity has to be between 1 and 10!"))
                return
            elseif ItemStack(treasure_name):is_known() == false then
                skywars.print_error(sender, S("@1 doesn't exist!", treasure_name))
                return
            end

            local item_id = skywars.generate_treasure_id(arena)
            local treasure = {
                name = treasure_name,
                rarity = rarity,
                count = count,
                preciousness = preciousness,
                id = item_id
            }
            table.insert(arena.treasures, treasure)

            arena_lib.change_arena_property(sender, "skywars", arena_name, "treasures", arena.treasures)
            skywars.print_msg(sender, "+ " .. from_treasure_to_string(treasure))

            skywars.reorder_treasures(arena)
        end)



    cmd:sub("addtreasure hand :arena :rarity:number :preciousness:int",
        function(sender, arena_name, preciousness, rarity)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local wielded_itemstack = get_wielded_item(sender)
            local treasure = {}

            if not arena or not wielded_itemstack then
                return
            elseif rarity < 1 or rarity > 10 then
                skywars.print_error(sender, S("Rarity has to be between 1 and 10!"))
                return
            end

            local item_id = skywars.generate_treasure_id(arena)
            treasure = {
                name = wielded_itemstack.name,
                rarity = rarity,
                count = wielded_itemstack.count,
                preciousness = preciousness,
                id = item_id
            }
            table.insert(arena.treasures, treasure)

            arena_lib.change_arena_property(sender, "skywars", arena_name, "treasures", arena.treasures)
            skywars.print_msg(sender, "+ " .. from_treasure_to_string(treasure))

            skywars.reorder_treasures(arena)
        end)



    cmd:sub("removetreasure hand :arena",
        function(sender, arena_name)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local found = {true, false} -- the first is used to repeat the for until nothing is found
            local wielded_itemstack = get_wielded_item(sender)

            if not arena or not wielded_itemstack then
                return
            end

            -- Removing all the treasures with that name.
            while found[1] do
                found[1] = false
                for i, treasure in pairs(arena.treasures) do
                    if treasure.name == wielded_itemstack.name then
                        table.remove(arena.treasures, i)
                        found[1] = true
                        found[2] = true
                    end
                end
            end
            arena_lib.change_arena_property(sender, "skywars", arena_name, "treasures", arena.treasures)

            if found[2] then
                skywars.print_msg(sender, S("@1 removed from @2!", wielded_itemstack.name, arena.name))
            else
                skywars.print_error(sender, S("Treasure not found!"))
            end

            skywars.reorder_treasures(arena)
        end)



    cmd:sub("removetreasure :arena :treasure",
        function(sender, arena_name, treasure_name)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local found = {true, false} -- the first is used to repeat the for until nothing is found

            if not arena then
                return
            end

            -- Removing all the treasures with that name.
            while found[1] do
                found[1] = false
                for i, treasure in pairs(arena.treasures) do
                    if treasure.name == treasure_name then
                        table.remove(arena.treasures, i)
                        i = i - 1
                        found[1] = true
                        found[2] = true
                    end
                end
            end
            arena_lib.change_arena_property(sender, "skywars", arena_name, "treasures", arena.treasures)

            if found[2] then
                skywars.print_msg(sender, S("@1 removed from @2!", treasure_name, arena_name))
            else
                skywars.print_error(sender, S("Treasure not found!"))
            end

            skywars.reorder_treasures(arena)
        end)



    cmd:sub("removetreasure id :arena :id:int",
        function(sender, arena_name, treasure_id)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local treasure_name = ""

            if not arena then
                return
            end

            for i = 1, #arena.treasures do
                if arena.treasures[i].id == treasure_id then
                    treasure_name = arena.treasures[i].name
                    table.remove(arena.treasures, i)
                    break
                end
            end
            arena_lib.change_arena_property(sender, "skywars", arena_name, "treasures", arena.treasures)

            if treasure_name ~= "" then
                skywars.print_msg(sender, S("@1 removed from @2!", treasure_name, arena_name))
            else
                skywars.print_error(sender, S("Treasure not found!"))
            end

            skywars.reorder_treasures(arena)
        end)



    cmd:sub("copytreasures :fromarena :toarena",
        function(sender, from_name, to_name)
            local from_arena, from_name = get_valid_arena(from_name, sender)
            local to_arena, to_name = get_valid_arena(to_name, sender, true)

            if not to_arena or not from_arena then
                return
            elseif from_arena == to_arena then
                skywars.print_error(sender, S("The arenas must be different!"))
                return
            end

            to_arena.treasures = table.copy(from_arena.treasures)

            arena_lib.change_arena_property(sender, "skywars", to_name, "treasures", to_arena.treasures)
            skywars.print_msg(sender, S("@1 treasures have been copied to @2!", from_name, to_name))
        end)



    cmd:sub("gettreasures :arena",
        function(sender, arena_name)
            local arena = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Treasures list:"))
            for i = 1, #arena.treasures do
                skywars.print_msg(sender, from_treasure_to_string(arena.treasures[i]) .. "\n\n")
            end
        end)



    cmd:sub("searchtreasure :arena :treasure",
        function(sender, arena_name, treasure_name)
            local arena, arena_name = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Treasures list:"))
            for i = 1, #arena.treasures do
                local treasure = arena.treasures[i]
                if treasure.name:find(treasure_name) then
                    skywars.print_msg(sender, from_treasure_to_string(treasure) .. "\n\n")
                end
            end
        end)



    cmd:sub("filter treasures rarity :arena :rarity:number",
        function(sender, arena_name, rarity)
            local arena, arena_name = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Treasures list:"))
            for i = 1, #arena.treasures do
                local treasure = arena.treasures[i]
                if treasure.rarity == rarity then
                    skywars.print_msg(sender, from_treasure_to_string(treasure) .. "\n\n")
                end
            end
        end)



    cmd:sub("filter treasures preciousness :arena :preciousness:number",
        function(sender, arena_name, preciousness)
            local arena, arena_name = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Treasures list:"))
            for i = 1, #arena.treasures do
                local treasure = arena.treasures[i]
                if treasure.preciousness == preciousness then
                    skywars.print_msg(sender, from_treasure_to_string(treasure) .. "\n\n")
                end
            end
        end)



    cmd:sub("filter treasures preciousness+rarity :arena :preciousness:number :rarity:number",
        function(sender, arena_name, preciousness, rarity)
            local arena, arena_name = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Treasures list:"))
            for i = 1, #arena.treasures do
                local treasure = arena.treasures[i]
                if treasure.preciousness == preciousness and treasure.rarity == rarity then
                    skywars.print_msg(sender, from_treasure_to_string(treasure) .. "\n\n")
                end
            end
        end)



    cmd:sub("addchest :minpreciousness:int :maxpreciousness:int :tmin:int :tmax:int",
        function(sender, min_preciousness, max_preciousness, min_treasures, max_treasures)
            local arena, arena_name = get_valid_arena("@", sender, true)
            local pos = get_looking_node_pos(sender)
            local exists = false

            if not pos then
                return
            elseif not arena then
                return
            end

            if min_treasures <= 0 or max_treasures <= 0 then
                skywars.print_error(sender, S("The minimum or maximum amount of treasures has to be greater than 0!"))
                return
            end

            local chest_id = skywars.generate_chest_id(arena)
            local chest =
            {
                pos = pos,
                min_preciousness = min_preciousness,
                max_preciousness = max_preciousness,
                min_treasures = min_treasures,
                max_treasures = max_treasures,
                id = chest_id
            }

            for i = 1, #arena.chests do
                if vector.equals(arena.chests[i].pos, pos) then
                    exists = true
                    break
                end
            end

            if exists then
                skywars.print_error(sender, S("The chest already exists!"))
                return
            end
            skywars.print_msg(sender, "+ " .. from_chest_to_string(chest))

            table.insert(arena.chests, chest)
            arena_lib.change_arena_property(sender, "skywars", arena_name, "chests", arena.chests)

            -- Check if there's a template matching this chest's params and auto-assign
            local templates = arena.chest_templates
            for _, template in pairs(templates) do
                if template.min_preciousness == min_preciousness
                    and template.max_preciousness == max_preciousness
                    and template.min_treasures == min_treasures
                    and template.max_treasures == max_treasures
                then
                    chest.template_id = template.id
                    arena_lib.change_arena_property(sender, "skywars", arena_name, "chests", arena.chests)

                    -- Place colored placeholder node
                    local placeholder_node = skywars.get_placeholder_node_name(template.color)
                    core.set_node(pos, {name = placeholder_node})
                    break
                end
            end
        end)



    cmd:sub("getchests :arena",
        function(sender, arena_name)
            local arena = get_valid_arena(arena_name, sender)

            if not arena then
                return
            end

            skywars.print_msg(sender, S("Chest list:"))
            for i = 1, #arena.chests do
                skywars.print_msg(sender, from_chest_to_string(arena.chests[i]) .. "\n\n")
            end
        end)



    cmd:sub("removechest",
        function(sender)
            local arena, arena_name = get_valid_arena("@", sender, true)
            local found = false
            local pos = get_looking_node_pos(sender)

            if not pos then
                return
            elseif not arena then
                return
            end

            for i = 1, #arena.chests do
                if vector.equals(arena.chests[i].pos, pos) then
                    table.remove(arena.chests, i)
                    found = true
                    break
                end
            end
            arena_lib.change_arena_property(sender, "skywars", arena_name, "chests", arena.chests)

            if found then
                skywars.print_msg(sender, S("Chest removed!"))
            else
                skywars.print_error(sender, S("Chest not found!"))
            end
        end)



    cmd:sub("inspect",
        function(sender)
            local arena, arena_name = get_valid_arena("@", sender)
            local found = false
            local pos = get_looking_node_pos(sender)

            if not pos then
                return
            elseif not arena then
                return
            end

            for i = 1, #arena.chests do
                local chest = arena.chests[i]
                if vector.equals(chest.pos, pos) then
                    skywars.print_msg(sender, from_chest_to_string(chest) .. "\n\n")
                    found = true
                    break
                end
            end

            if not found then
                skywars.print_error(sender, S("Chest not found!"))
            end
        end)



    cmd:sub("removechest id :arena :id:int",
        function(sender, arena_name, chest_id)
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local found = false

            if not arena then
                return
            end

            for i = 1, #arena.chests do
                if arena.chests[i].id == id then
                    table.remove(arena.chests, i)
                    found = true
                    break
                end
            end
            arena_lib.change_arena_property(sender, "skywars", arena_name, "chests", arena.chests)

            if found then
                skywars.print_msg(sender, S("Chest removed!"))
            else
                skywars.print_error(sender, S("Chest not found!"))
            end
        end)


    cmd:sub("chests_without_template :arena",
        function(sender, arena_name)
            local arena, arena_name = get_valid_arena(arena_name, sender)

            if not arena then return end

            local templates = arena.chest_templates
            local unassigned = {}

            for _, chest in ipairs(arena.chests or {}) do
                if not chest.template_id then
                    table.insert(unassigned, chest)
                else
                    local tpl = templates[chest.template_id]
                    if not tpl then
                        table.insert(unassigned, chest)
                    end
                end
            end

            if #unassigned == 0 then
                skywars.print_msg(sender, S("All chests have valid templates."))
                return
            end

            skywars.print_msg(sender, S("Chests without template (@1):", #unassigned))
            for _, chest in ipairs(unassigned) do
                skywars.print_msg(sender, from_chest_to_string(chest))
            end
        end)



    -------------------
    -- ! KITS CMDS ! --
    -------------------

    cmd:sub("createkit :name :item",
        function(sender, kit_name, item_name)
            local kits = skywars.load_table("kits")

            if kits[kit_name] then
                skywars.print_error(sender, S("@1 already exists!", kit_name))
                return
            end

            -- Try to get texture from item if possible
            local resolved_texture = get_texture_from_item(item_name)
            if resolved_texture == "" then resolved_texture = item_name end
            kits[kit_name] = {texture = resolved_texture, items = {}}
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("Kit @1 created!", kit_name))
        end)



    cmd:sub("additem :kit :item :count:int",
        function(sender, kit_name, item_name, item_count)
            local kits = skywars.load_table("kits")
            local itemstack = {}

            if ItemStack(item_name):is_known() == false then
                skywars.print_error(sender, S("@1 doesn't exist!", item_name))
                return
            elseif kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            elseif item_count <= 0 then
                skywars.print_error(sender, S("Count has to be greater than 0!"))
                return
            end

            itemstack.name = item_name
            itemstack.count = item_count

            table.insert(kits[kit_name].items, itemstack)
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("x@1 @2 added to @3!", item_count, item_name, kit_name))
        end)



    cmd:sub("additem hand :kit",
        function(sender, kit_name)
            local kits = skywars.load_table("kits")
            local wielded_itemstack = get_wielded_item(sender)

            if not wielded_itemstack then
                return
            elseif kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            table.insert(kits[kit_name].items, wielded_itemstack)
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("x@1 @2 added to @3!", wielded_itemstack.count, wielded_itemstack.name, kit_name))
        end)



    cmd:sub("deletekit :kit",
        function(sender, kit_name)
            local kits = skywars.load_table("kits")

            if kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            kits[kit_name] = nil
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("Kit @1 deleted!", kit_name))
        end)



    cmd:sub("removeitem hand :kit",
        function(sender, kit_name)
            local kits = skywars.load_table("kits")
            local wielded_itemstack = get_wielded_item(sender)
            local found = false

            if not wielded_itemstack then
                return
            elseif kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", wielded_itemstack.name))
                return
            end

            for i = 1, #kits[kit_name].items do
                if kits[kit_name].items[i].name == wielded_itemstack.name then
                    table.remove(kits[kit_name].items, i)
                    found = true
                    break
                end
            end
            skywars.store_table("kits", kits)

            if found then
                skywars.print_msg(sender, S("@1 removed from @2!", wielded_itemstack.name, kit_name))
            else
                skywars.print_error(sender, S("@1 doesn't exist!", wielded_itemstack.name))
            end
        end)



    cmd:sub("removeitem :kit :item",
        function(sender, kit_name, item_name)
            local kits = skywars.load_table("kits")
            local itemstack = {}
            local found = false

            if kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            itemstack.name = item_name
            itemstack.count = item_count

            for i = 1, #kits[kit_name].items do
                if kits[kit_name].items[i].name == item_name then
                    table.remove(kits[kit_name].items, i)
                    found = true
                    break
                end
            end
            skywars.store_table("kits", kits)

            if found then
                skywars.print_msg(sender, S("@1 removed from @2!", item_name, kit_name))
            else
                skywars.print_error(sender, S("@1 doesn't exist!", item_name))
            end
        end)



    cmd:sub("kittexture :kit :item",
        function(sender, kit_name, item_name)
            local kits = skywars.load_table("kits")

            if kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            if ItemStack(item_name):is_known() == false then
                skywars.print_error(sender, S("@1 doesn't exist!", item_name))
                return
            end

            local texture = get_texture_from_item(item_name)
            if texture == "" then
                skywars.print_error(sender, S("@1 doesn't have a usable texture!", item_name))
                return
            end

            kits[kit_name].texture = texture
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("@1 texture set to @2!", kit_name, texture))
        end)


    cmd:sub("resetkit :kit",
        function(sender, kit_name)
            local kits = skywars.load_table("kits")

            if kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            kits[kit_name].items = {}
            skywars.store_table("kits", kits)

            skywars.print_msg(sender, S("@1 reset!", kit_name))
        end)



    cmd:sub("getkits",
        function(sender)
            local kits = skywars.load_table("kits")

            skywars.print_msg(sender, S("Kits list:"))
            for name in pairs(kits) do
                skywars.print_msg(sender, name)
            end
        end)



    cmd:sub("getitems :kit",
        function(sender, kit_name)
            local kits = skywars.load_table("kits")

            if kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            skywars.print_msg(sender, S("@1 items:", kit_name))
            for i = 1, #kits[kit_name].items do
                skywars.print_msg(sender, "x" .. kits[kit_name].items[i].count .. " " .. kits[kit_name].items[i].name)
            end
        end)



    cmd:sub("arenakit add :arena :kit",
        function(sender, arena_name, kit_name)
            local kits = skywars.load_table("kits")
            local arena, arena_name = get_valid_arena(arena_name, sender, true)

            if not arena then
                return
            elseif kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            table.insert(arena.kits, kit_name)

            arena_lib.change_arena_property(sender, "skywars", arena_name, "kits", arena.kits)
            skywars.print_msg(sender, S("@1 added to @2!", kit_name, arena_name))
        end)



    cmd:sub("arenakit remove :arena :kit",
        function(sender, arena_name, kit_name)
            local kits = skywars.load_table("kits")
            local arena, arena_name = get_valid_arena(arena_name, sender, true)
            local found = false

            if not arena then
                return
            elseif kits[kit_name] == nil then
                skywars.print_error(sender, S("@1 doesn't exist!", kit_name))
                return
            end

            for i = 1, #arena.kits do
                if arena.kits[i] == kit_name then
                    table.remove(arena.kits, i)
                    found = true
                    break
                end
            end

            arena_lib.change_arena_property(sender, "skywars", arena_name, "kits", arena.kits)
            if found then
                skywars.print_msg(sender, S("@1 removed from @2!", kit_name, arena_name))
            else
                skywars.print_error(sender, S("Kit not found!"))
            end
        end)



    cmd:sub("copykits :fromarena :toarena",
        function(sender, from_name, to_name)
            local from_arena, from_name = get_valid_arena(from_name, sender)
            local to_arena, to_name = get_valid_arena(to_name, sender, true)

            if not from_arena or not to_arena then
                return
            elseif from_arena == to_arena then
                skywars.print_error(sender, S("The arenas must be different!"))
                return
            end

            to_arena.kits = table.copy(from_arena.kits)

            arena_lib.change_arena_property(sender, "skywars", to_name, "kits", to_arena.kits)
            skywars.print_msg(sender, S("@1 kits have been copied to @2!", from_name, to_name))
        end)



    --------------------
    -- ! DEBUG CMDS ! --
    --------------------

    cmd:sub("getpos",
        function(sender)
            local pos = minetest.get_player_by_name(sender):get_pos()
            local readable_pos = "[X Y Z] " .. minetest.pos_to_string(pos, 1)

            skywars.print_msg(sender, readable_pos)
        end)
end, {

    description = [[

        ADMIN COMMANDS
        (Use /help skywars to read it all)


        - tutorial


        TREASURES:

        - addtreasure <arena name> <item> <count> <preciousness>
          <rarity (min 1.0, max 10.0)>
        - addtreasure hand <arena name> <preciousness>
          <rarity (min 1.0, max 10.0)>
        - gettreasures <arena name>
        - searchtreasure <arena name> <treasure name>: shows all the treasures with that name
        - filter treasures rarity <arena name> <rarity>
        - filter treasures preciousness <arena name> <preciousness>
        - filter treasures preciousness+rarity <arena name> <preciousness> <rarity>
        - removetreasure <arena name> <treasure name>: remove all treasures with that name
        - removetreasure hand <arena name>
        - removetreasure id <arena name> <treasure id>
        - copytreasures <(from) arena name> <(to) arena name>


        CHESTS:

        - addchest <min_preciousness> <max_preciousness> <min_treasures_amount (min. 1)>
          <max_treasures_amount>
        - getchests <arena name>
        - inspect: gives you information about the chest you're looking at
        - removechest
        - removechest id <arena name> <id>


        KITS:

        - createkit <kit name> <represeting item name>
        - deletekit <kit name>
        - additem <kit name> <item> <count>
        - additem hand <kit name>
        - kittexture <kit name> <represeting item name>
        - removeitem <kit name> <item>
        - removeitem hand <kit name>
        - arenakit add <arena name> <kit name>
        - arenakit remove <arena name> <kit name>
        - getkits
        - resetkit <kit name>
        - getitems <kit name>
        - copykits <(from) arena name> <(to) arena name>


        DEBUG (don't use them if you don't know what you're doing):

        - getpos
        ]],
    privs = {skywars_admin = true}
})



minetest.register_privilege("skywars_admin", {
    description = "With this you can use /skywars"
})



function get_valid_arena(arena_name, sender, property_is_changing)
    local arena = nil

    if arena_name == "@" then
        local player_pos = minetest.get_player_by_name(sender):get_pos()
        arena = arena_lib.get_arena_by_pos(player_pos)
        if arena then arena_name = arena.name end
    else
        local id, arena_ = arena_lib.get_arena_by_name("skywars", arena_name)
        arena = arena_
    end

    if not arena then
        skywars.print_error(sender, S("@1 doesn't exist!", arena_name))
        return nil
    elseif arena.enabled and property_is_changing then
        arena_lib.disable_arena(sender, "skywars", arena_name)
        local couldnt_disable = arena.enabled

        if couldnt_disable then
            skywars.print_error(sender, S("@1 must be disabled!", arena_name))
            return nil
        end
    end

    return arena, arena_name
end



function get_looking_node_pos(pl_name)
    local player = minetest.get_player_by_name(pl_name)
    local look_dir = player:get_look_dir()
    local pos_head = vector.add(player:get_pos(), {x = 0, y = 1.5, z = 0})
    local result, pos = minetest.line_of_sight(
        vector.add(pos_head, vector.divide(look_dir, 4)),
        vector.add(pos_head, vector.multiply(look_dir, 10))
    )

    if result then
        skywars.print_error(pl_name, S("You're not looking at anything!"))
        return nil
    end

    return pos
end



function from_chest_to_string(chest)
    local chest_pos = minetest.pos_to_string(chest.pos, 0)
    return S(
        "ID: @1, position: @2, preciousness: @3-@4, treasures amount: @5-@6",
        chest.id, chest_pos, chest.min_preciousness, chest.max_preciousness,
        chest.min_treasures, chest.max_treasures
    )
end



function from_treasure_to_string(treasure)
    return S(
        "ID: @1, name: @2, rarity: @3, preciousness: @4, count: @5",
        treasure.id, treasure.name, treasure.rarity, treasure.preciousness, treasure.count
    )
end



function get_wielded_item(player)
    local item_name = minetest.get_player_by_name(player):get_wielded_item():get_name()
    local item_count = minetest.get_player_by_name(player):get_wielded_item():get_count()
    local itemstack = {}

    if ItemStack(item_name):is_known() == false then
        skywars.print_error(player, S("@1 doesn't exist!", item_name))
        return nil
    elseif item_name == "" then
        skywars.print_error(player, S("Your hand is empty!"))
        return nil
    end

    itemstack.name = item_name
    itemstack.count = item_count

    return itemstack
end



-- Returns the best texture for an item name, or empty string if not found
function skywars.get_texture_from_item(item_name)
    local item_def = core.registered_items[item_name]
    if not item_def then return "" end
    if item_def.inventory_image and item_def.inventory_image ~= "" then
        return item_def.inventory_image
    elseif item_def.wield_image and item_def.wield_image ~= "" then
        return item_def.wield_image
    elseif item_def.tiles and item_def.tiles[1] then
        local tiles = item_def.tiles
        local top_tile = tiles[1] or tiles[1]
        local side_tile = tiles[3] or tiles[1]
        if type(top_tile) == "table" and top_tile.name then
            top_tile = top_tile.name
        end
        if type(side_tile) == "table" and side_tile.name then
            side_tile = side_tile.name
        end
        return core.inventorycube(top_tile, side_tile, side_tile)
    end
    return ""
end



-- Keep local reference for backward compatibility in this file
local get_texture_from_item = skywars.get_texture_from_item
