local S = skywars.T


function skywars.print_error(pl_name, msg)
    minetest.chat_send_player(pl_name, minetest.colorize("#e6482e", skywars_settings.prefix .. msg))
end

function skywars.print_msg(pl_name, msg)
    minetest.chat_send_player(pl_name, skywars_settings.prefix .. msg)
end

function skywars.add_info_to_itemstack(itemstack)
    local def = core.registered_tools[itemstack:get_name()]

    -- if it's not a tool, return the itemstack as is.
    if not def then
        return itemstack
    end

    -- Add the info to the itemstack metadata.
    local meta = itemstack:get_meta()
    local base_descrition = def.description or def.short_description or ""
    local item_name = itemstack:get_name()

    -- Determine enchantability
    local enchantability = core.get_item_group(item_name, "enchantability")
    local enchantable = enchantability > 0

    -- Determine tier level based on groups
    local tier_level = ""
    local s = core.colorize("#f4b41b", "★")
    local es = core.colorize("#f4b41b", "☆")
    local es_g = core.colorize("#cfc6b8", "☆")
    local lp = core.colorize("#cfc6b8", "[")
    local rp = core.colorize("#cfc6b8", "]")

    if not def.armor_groups then
        if item_name:match("wood") then
            tier_level = lp .. es .. es_g .. es_g .. rp .. " "    -- Wood level
        elseif item_name:match("stone") then
            tier_level = lp .. es .. es .. es_g .. rp .. " "   -- Stone level
        elseif item_name:match("bronze") then
            tier_level = lp .. es .. es .. es .. rp .. " "    -- Bronze level
        elseif item_name:match("steel") then
            tier_level = lp .. s .. es .. es .. rp .. " "   -- Steel level
        elseif item_name:match("diamond") then
            tier_level = lp .. s .. s .. es .. rp .. " "  -- Diamond level
        elseif item_name:match("mese") then
            tier_level = lp .. s .. s .. s .. rp .. " " -- Mese level
        end
    else
        if item_name:match("bronze") then
            tier_level = lp .. s .. es .. es .. rp .. " "    -- Bronze level
        elseif item_name:match("steel") then
            tier_level = lp .. s .. s .. es .. rp .. " "   -- Steel level
        elseif item_name:match("diamond") then
            tier_level = lp .. s .. s .. s .. rp .. " "  -- Diamond level
        end
    end

    local enchantability_tier =
        enchantability < 10 and S("Easily Enchantable")
        or enchantability < 16 and S("Fairly Enchantable")
        or S("Highly Enchantable")

    -- Construct the new description
    local new_description =
        tier_level .. base_descrition .. "\n" ..
        (enchantable and (core.colorize("#cfc6b8", "☞ " .. enchantability_tier) .. "\n") or "")

    meta:set_string("description", new_description)

    -- Return the modified itemstack.
    return itemstack
end
