local function add_privs() end
local function remove_privs() end
local function drop_items() end
local function block_player() end
local function keep_teleporting() end
local update_timer_hud = skywars.update_timer_hud
local kill_players_out_map = skywars.kill_players_out_map
local S = skywars.T
local is_3d_armor_enabled = minetest.get_modpath("3d_armor")
local get_node = core.get_node
local add_node = core.set_node
local remove_node = core.remove_node


minetest.register_on_joinplayer(function(player)
  remove_privs(player:get_player_name())
end)



arena_lib.on_join("skywars", function(pl_name, arena, as_spectator, was_spectator)
  skywars.generate_HUD(arena, pl_name)
end)



arena_lib.on_load("skywars", function(arena)
  arena.players_original_amount = arena.players_amount

  for pl_name in pairs(arena.players) do
    local player = minetest.get_player_by_name(pl_name)

    -- Create barrier cage to immobilize player during loading
    block_player(player)

    player:get_inventory():add_item("main", "skywars:kit_selector")

    if is_3d_armor_enabled then
      skywars.HUD_armor_create(player)
    end
  end

  arena_lib.HUD_send_msg_all(
    "broadcast",
    arena,
    S("Select a kit using the item in your inventory"),
    skywars_settings.loading_time
  )

  -- Countdown timer for loading phase
  local function update_countdown(remaining_time)
    if remaining_time <= 0 or not arena.in_loading then
      return
    end

    arena_lib.HUD_send_msg_all(
      "hotbar",
      arena,
      S("Match starts in: @1", remaining_time),
      1
    )

    if remaining_time > 1 then
      minetest.after(1, function()
        update_countdown(remaining_time - 1)
      end)
    end
  end

  -- Start the countdown
  update_countdown(skywars_settings.loading_time)
end)



arena_lib.on_start("skywars", function(arena)
  arena.match_id = math.random(1, 9999999999)
  arena.chests_refilled = false
  arena.minimap_enabled = false

  -- Track start time for invincibility period
  arena.start_time = minetest.get_gametime()

  skywars.place_chests(arena)

  for pl_name in pairs(arena.players) do
    local player = minetest.get_player_by_name(pl_name)

    minetest.sound_play("sw_start", {to_player = pl_name})
    add_privs(pl_name)
    skywars.generate_HUD(arena, pl_name)
    player:set_physics_override({
      speed = skywars_settings.player_speed,
      gravity = 1,
      jump = 1.1
    })
    skywars.activate_enderpearl(player, arena)

    local inv = player:get_inventory()
    if inv:contains_item("main", "skywars:kit_selector") or inv:contains_item("craft", "skywars:kit_selector") then
      skywars.select_kit(pl_name, skywars.load_table("kits")[arena.kits[1]])
    end
  end
end)



arena_lib.on_celebration("skywars", function(arena, winners)
  for pl_name in pairs(arena.players) do
    local player = minetest.get_player_by_name(pl_name)

    minetest.sound_play("sw_win", {to_player = pl_name})
    remove_privs(pl_name)
    skywars.block_enderpearl(player, arena)
  end

  -- Team mode
  -- winners can be a teamID (integer) when teams are enabled.
  if type(winners) == "number" then
    local winning_team = winners

    for p_name, p_data in pairs(arena.players) do
      if p_data.teamID == winning_team and p_data.fearless then
        skywars.award_achievement(p_name, "skywars:fearless")
      end
    end

    return
  end

  -- Single player
  --                               v could be "Nobody"
  if type(winners) == "string" and minetest.get_player_by_name(winners) then
    local pl_kills = arena.players[winners].kills

    if pl_kills > 2 and pl_kills == arena.players_original_amount - 1 then
      skywars.award_achievement(winners, "skywars:lone_wolf")
    end

    if arena.players_original_amount > 2 and arena.players[winners].fearless then
      skywars.award_achievement(winners, "skywars:fearless")
    end
  end

  -- Duo mode
  if type(winners) == "table" then
    local p1 = winners[1]
    local p2 = winners[2]

    if arena.players[p1].fearless and arena.players[p2].fearless then
      skywars.award_achievement(p1, "skywars:fearless")
      skywars.award_achievement(p2, "skywars:fearless")
    end
  end
end)



arena_lib.on_end("skywars", function(arena, winners, is_forced)
  for pl_name in pairs(arena.players_and_spectators) do
    local player = minetest.get_player_by_name(pl_name)

    remove_privs(pl_name)
    skywars.remove_HUD(arena, pl_name)
    skywars.remove_armor(player)
    minetest.close_formspec(pl_name, "")
  end
end)



arena_lib.on_death("skywars", function(arena, pl_name, reason)
  local player = minetest.get_player_by_name(pl_name)

  if reason.type == "punch" then
    if reason.object and reason.object:is_player() then
      local killer = reason.object:get_player_name()
      local killer_health = reason.object:get_hp()

      skywars.print_msg(pl_name, S("@1 killed you with @2 HPs", killer, killer_health))

      -- in case the killer died before the killed player did
      if arena.players[killer] then
        arena.players[killer].kills = arena.players[killer].kills + 1
        skywars.set_players_killed_hud(killer, arena.players[killer].kills)
      end

      if arena.initial_time - arena.current_time <= 10 then
        skywars.award_achievement(killer, "skywars:fast_and_furious")
      end
    end
  end

  for pl_name, _ in pairs(arena.players) do
    minetest.sound_play("sw_pl_dead", {to_player = pl_name})
  end

  drop_items(player)
  skywars.block_enderpearl(player, arena)
  skywars.remove_armor(player)
end)



arena_lib.on_prequit("skywars", function(arena, pl_name)
  if arena.in_loading then
    return false
  else
    return true
  end
end)



arena_lib.on_quit("skywars", function(arena, pl_name, is_spectator, reason)
  local player = minetest.get_player_by_name(pl_name)

  remove_privs(pl_name)
  if not is_spectator then
    skywars.update_players_counter(arena)
  end
  skywars.remove_HUD(arena, pl_name)
  skywars.remove_armor(player)
  skywars.block_enderpearl(player, arena)
end)



arena_lib.on_enable("skywars", function(arena, pl_name)
  pl_name = pl_name:gsub("@", "")

  if arena.treasures[1] == nil then
    skywars.print_error(pl_name, S("You didn't set the treasures!"))
    return false
  elseif arena.chests[1] == nil then
    skywars.print_error(pl_name, S("You didn't set the chests!"))
    return false
  end

  return true
end)



arena_lib.on_time_tick("skywars", function(arena)
  kill_players_out_map(arena)
  update_timer_hud(arena)

  -- Check if we should refill chests at half-time
  if not arena.chests_refilled and arena.initial_time and arena.current_time then
    local half_time = arena.initial_time / 2
    if arena.current_time <= half_time then
      arena.chests_refilled = true
      skywars.fill_chests(arena)
      arena_lib.HUD_send_msg_all("title", arena, S("Chests have been refilled!"), 3.5)
    end
  end

  -- Check if we should enable minimap at 2/3 of the game time
  if not arena.minimap_enabled and arena.initial_time and arena.current_time then
    local two_thirds_time = arena.initial_time / 3
    if arena.current_time <= two_thirds_time then
      arena.minimap_enabled = true

      for pl_name in pairs(arena.players) do
        local player = core.get_player_by_name(pl_name)
        if player then
          player:hud_set_flags({minimap = true})
        end
      end

      arena_lib.HUD_send_msg_all("title", arena, S("Minimap is now available!"), 3.5)
    end
  end
end)



arena_lib.on_timeout("skywars", function(arena)
  arena_lib.load_celebration("skywars", arena, S("Nobody"))
  arena_lib.send_message_in_arena(arena, "players", skywars_settings.prefix .. S("Time is out, the match is over!"))
end)



function add_privs(pl_name)
  local privs = minetest.get_player_privs(pl_name)
  local player = minetest.get_player_by_name(pl_name)

  -- Preventing players with noclip to fall when placing nodes.
  if privs.noclip then
    player:get_meta():set_string("sw_can_noclip", "true")
    privs.noclip = nil
  else
    player:get_meta():set_string("sw_can_noclip", "false")
  end

  if privs.creative then
    player:get_meta():set_string("sw_can_creative", "true")
    privs.creative = nil
  else
    player:get_meta():set_string("sw_can_creative", "false")
  end

  minetest.set_player_privs(pl_name, privs)
end

function remove_privs(pl_name)
  local privs = minetest.get_player_privs(pl_name)
  local player = minetest.get_player_by_name(pl_name)

  if player:get_meta():get_string("sw_can_noclip") == "true" then
    privs.noclip = true
  end

  if player:get_meta():get_string("sw_can_creative") == "true" then
    privs.creative = true
  end

  minetest.set_player_privs(pl_name, privs)
end

function drop_items(player)
  local inv = player:get_inventory():get_list("main")
  local noise = 2

  for i, itemstack in pairs(inv) do
    local pl_pos = player:get_pos()
    local random_x = pl_pos.x + math.random() + math.random(-noise - 1, noise - 1)
    local random_z = pl_pos.z + math.random() + math.random(-noise - 1, noise - 1)
    local random_pos = {
      x = random_x,
      y = pl_pos.y,
      z = random_z
    }

    minetest.item_drop(itemstack, player, random_pos)
  end
end

function block_player(player)
  minetest.after(0.1, function()
    local original_pos = player:get_pos()

    player:add_velocity(vector.multiply(player:get_velocity(), -1))
    player:set_physics_override({gravity = 0.01, jump = 0, speed = 0.1})

    keep_teleporting(player:get_player_name(), original_pos, skywars_settings.loading_time - 1)
  end)
end

function keep_teleporting(pl_name, pos, seconds, current_second)
  local step = 1
  current_second = current_second or 1
  if current_second > seconds then return end

  minetest.after(step, function()
    local player = minetest.get_player_by_name(pl_name)

    if not player or not arena_lib.is_player_in_arena(pl_name) then
      return
    end

    player:add_velocity(vector.multiply(player:get_velocity(), -1))
    player:set_pos(pos)
    keep_teleporting(pl_name, pos, seconds, current_second + step)
  end)
end

arena_lib.on_eliminate("skywars", function(arena, pl_name, xc_name, p_properties)
  local player = minetest.get_player_by_name(pl_name)
  if player then
    minetest.close_formspec(pl_name, "")
  end
  skywars.update_players_counter(arena)
end)



core.register_on_craft(function(itemstack, player, old_craft_grid, craft_inv)
  if not itemstack or type(itemstack) ~= "userdata" then
    return
  end

  if arena_lib.is_player_in_arena(player:get_player_name(), "skywars") then
    return skywars.add_info_to_itemstack(itemstack)
  end
end)



arena_lib.on_region_trespass("skywars", function(arena, players_outside)
  for i, pl in pairs(players_outside) do
    pl:set_hp(0, {type="fall"})
    skywars.print_msg(pl:get_player_name(), S("You were killed for leaving the arena boundaries!"))
  end
end)