local CHECK_INTERVAL = 2

local get_node = core.get_node_or_nil
local check_timer = 0
local a_lib = arena_lib
local old_is_protected = core.is_protected



local function is_compenetrating_with_any_player(pos, arena)
    for p_name in pairs(arena.players) do
        local player = core.get_player_by_name(p_name)
        if player then
            local feet_pos = vector.round(player:get_pos())
            local head_pos = vector.add(feet_pos, {x = 0, y = 1, z = 0})
            if vector.equals(pos, head_pos) then
                return true
            end
        end
    end
    return false
end


function core.is_protected(pos, pl_name)
    if a_lib.is_player_in_arena(pl_name, "skywars") then
        local arena = a_lib.get_arena_by_player(pl_name, "skywars")
        if arena and is_compenetrating_with_any_player(pos, arena) then
            return true
        end
    else
        return old_is_protected(pos, pl_name)
    end
end
