-- Tracks the last block placement time for each player to prevent spam clicking
local last_place_time = {}
local MIN_PLACE_INTERVAL = 0.11


core.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
	if not placer or not placer:is_player() then
		return false
	end

	local pl_name = placer:get_player_name()
	
	if not arena_lib.is_player_in_arena(pl_name, "skywars") then
		return false
	end

	local current_time = core.get_us_time() / 1000000
	local last_time = last_place_time[pl_name] or 0
	
	if current_time - last_time < MIN_PLACE_INTERVAL then
		-- Spam click detected: remove the placed node and give back the item
		core.remove_node(pos)
		local inv = placer:get_inventory()
		if inv then
			inv:add_item("main", ItemStack(newnode.name))
		end
		return true
	end
	
	last_place_time[pl_name] = current_time
	return false
end)