local function spawn_particle(player, damage)
   local dmg_mult = math.max(1, damage)

   core.add_particlespawner({
      amount = damage * 5,
      time = 0.1,
      minacc = {x = 0, y = -3.6, z = 0},
      maxacc = {x = 0, y = -3.6, z = 0},
      minsize = 3,
      maxsize = 5.5,
      texture = {
         name = "sw_hit.png",
         alpha_tween = {1, 0.6},
         scale_tween = {
            {x = 1,   y = 1},
            {x = 0.6, y = 0.6},
         },
      },
      attract = {
         kind = "point",
         strength = -0.6 * dmg_mult,
         origin_attached = player,
         origin = {x = 0, y = 1, z = 0},
      },
      radius = 0.25,
      collisiondetection = false,
      minexptime = 0.2,
      maxexptime = 0.3,
      pos = {
         max = vector.add(player:get_pos(), {x = 0.3, y = 1.4, z = 0.3}),
         min = vector.add(player:get_pos(), {x = -0.3, y = 0.5, z = -0.3}),
      }
   })
end



local function apply_custom_knockback(player, hitter, dir, damage)
   if skywars_settings and skywars_settings.custom_knockback_enabled == false then
      return
   end

   local dmg = tonumber(damage) or 0
   if dmg <= 0 then
      return
   end

   local pl_pos = player:get_pos()
   local hit_pos = hitter:get_pos()

   -- Hack to preventing KB when using non-melee weapons
   local wielded_item = hitter:get_wielded_item()
   local item_def = core.registered_items[wielded_item:get_name()]
   local wield_reach = item_def and item_def.range or 4.0
   if vector.distance(pl_pos, hit_pos) > wield_reach then
      return
   end

   local horiz_dir = {x = dir.x, y = 0, z = dir.z}
   local horiz_len = vector.length(horiz_dir)

   if horiz_len < 0.001 then
      horiz_dir = {x = pl_pos.x - hit_pos.x, y = 0, z = pl_pos.z - hit_pos.z}
      horiz_len = vector.length(horiz_dir)
   end

   if horiz_len < 0.001 then
      return
   end

   horiz_dir = vector.divide(horiz_dir, horiz_len)

   local kb_h_base = skywars_settings.custom_kb_horizontal_base or 3
   local kb_h_per_dmg = skywars_settings.custom_kb_horizontal_per_damage or 2.5
   local kb_h_max = skywars_settings.custom_kb_horizontal_max or 12
   local kb_h = math.min(kb_h_base + dmg * kb_h_per_dmg, kb_h_max)

   local kb_y_base = skywars_settings.custom_kb_vertical_base or 2.5
   local kb_y_per_dmg = skywars_settings.custom_kb_vertical_per_damage or 0.8
   local kb_y_max = skywars_settings.custom_kb_vertical_max or 5
   local kb_y = math.min(kb_y_base + dmg * kb_y_per_dmg, kb_y_max)

   player:add_velocity({
      x = horiz_dir.x * kb_h,
      y = kb_y,
      z = horiz_dir.z * kb_h,
   })
end



core.register_on_punchplayer(function(player, hitter, time_from_last_punch, tool_capabilities, dir, damage)
   local pl_name = player:get_player_name()
   local arena = arena_lib.get_arena_by_player(pl_name)

   if
       not arena_lib.is_player_in_arena(pl_name, "skywars")
       or not arena.players[pl_name]
       or not (arena.players_original_amount > 0) -- match has actually started
       or damage <= 0
   then
      return
   end

   if arena.teams_enabled then
      local hitter_name = hitter:get_player_name()
      if arena.players[hitter_name] and arena_lib.is_player_in_same_team(arena, pl_name, hitter_name) then
         return
      end
   end

   spawn_particle(player, damage)

   local gain = math.min(0.8 + damage * 0.1, 1.0)
   local sound = {name = "sw_hit", gain = gain, pitch = math.random(95, 110) / 100}

   -- if player near enough to hitter, reproduce non-positional for them
   local dist = vector.distance(player:get_pos(), hitter:get_pos())
   if dist <= 12 then
      core.sound_play(sound, {to_player = player:get_player_name()}, true)
      sound.exclude_player = player:get_player_name()
   end
   core.sound_play(sound, {pos = player:get_pos(), max_hear_distance = 12, exclude_player = player:get_player_name()}, true)

   if hitter and hitter:is_player() then
      local hitter_name = hitter:get_player_name()
      if arena.players[hitter_name] then
         apply_custom_knockback(player, hitter, dir, damage)
      end
   end
end)
