dofile(minetest.get_modpath("skywars") .. "/SETTINGS.lua")
skywars = {}
skywars.T = minetest.get_translator("skywars")
local disabled_damage_types_ = {}

-- Predeclare a pool of team names.
local team_names = {}
for i = 1, 8 do
  team_names[i] = tostring(i)
end


if skywars_settings.fall_damage_disabled then
  disabled_damage_types_ = {}
end

arena_lib.register_minigame("skywars", {
  name = "Skywars",
  icon = "skywars_icon.png",
  prefix = skywars_settings.prefix,

  teams = team_names,
  teams_color_overlay = {"orange", "blue", "green", "magenta", "skin_cocoa", "purple", "azure", "white"},
  can_disable_teams = true,
  variable_teams_amount = true,
  friendly_fire = false,
  chat_settings = {
    is_team_chat_default = true,
  },

  join_while_in_progress = false,
  load_time = skywars_settings.loading_time,
  celebration_time = skywars_settings.celebration_time,

  hotbar = {
    slots = 8,
    background_image = "arenalib_gui_hotbar8.png"
  },

  sounds = {
    eliminate = false,
  },

  temp_properties = {
    players_original_amount = 0,
    start_time = 0,
    chests_refilled = false,
    minimap_enabled = false
  },
  properties = {
    chests = {},
    chest_templates = {},
    treasures = {}, -- Items to put in the chests.
    min_pos = {},
    max_pos = {},
    min_y = 0,
    kits = {},
  },
  player_properties = {
    kills = 0,
    fearless = true,
    last_hit_by = "", -- pl_name
  },
  in_game_physics = {
    sneak_glitch = false,
    new_move = true,
    jump = 1.1
  },
  hud_flags = {
    minimap = false
  },
  min_version = 41,
  can_build = true,
  time_mode = "decremental",
  disabled_damage_types = disabled_damage_types_,
  eliminate_on_death = true,
  regenerate_map = true
})



dofile(minetest.get_modpath("skywars") .. "/src/debug/debug_utils.lua")

dofile(minetest.get_modpath("skywars") .. "/src/hit_effect.lua")
dofile(minetest.get_modpath("skywars") .. "/src/storage.lua")
dofile(minetest.get_modpath("skywars") .. "/src/nodes.lua")
dofile(minetest.get_modpath("skywars") .. "/src/utils.lua")
dofile(minetest.get_modpath("skywars") .. "/src/utils_sanitize.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_map_handler/map_utils.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_map_handler/chests/chest_setter.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_map_handler/chests/treasures.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_compatible_mods/enderpearl/init_enderpearl.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_compatible_mods/3d_armor/init_3d_armor.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_compatible_mods/achievements_lib/achievements.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_hud/hud_manager.lua")
dofile(minetest.get_modpath("skywars") .. "/src/commands.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_arena_lib/arena_callbacks.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_editor/chest_templates.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_editor/chest_template_node.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_editor/editor_gui.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_editor/init_editor.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_kits/formspec.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_kits/kit_items.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_player/auto_equip_items.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_player/damage_tracker.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_player/loading_phase_damage.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_player/anti_compenetration.lua")
dofile(minetest.get_modpath("skywars") .. "/src/_player/anti_spamclick.lua")
