core.register_on_player_hpchange(function(player, hp_change, reason) 
    local pl_name = player:get_player_name()
    local arena = arena_lib.get_arena_by_player(pl_name)

    -- Only apply damage protection to skywars players
    if not arena_lib.is_player_in_arena(pl_name, "skywars")
       or not arena
       or not arena.players[pl_name]
       or not (arena.players_original_amount > 0)
    then
        return hp_change
    end

    -- Prevent all damage during loading phase
    if arena.in_loading then
        if hp_change < 0 then
            return 0
        end
    end

    -- Check if it's within the first 4 seconds after game start (invincibility period)
    if arena.start_time and core.get_gametime() - arena.start_time < 4 then
        if hp_change < 0 then
            return 0
        end
    end

    return hp_change
end, true)
