minetest.register_node("antro_ore:antro_ore_block", {
	description = ("Antro ore"),
	tiles = {"antro_ore_block.png"},
	groups = {stone=2, cracky=3},
	drop = "antro_ore:antro_ore_block",
	is_ground_content = true,
})

--Define antro_ore_Ingot node
minetest.register_craftitem("antro_ore:antro_ore_ingot", {
	description = ("Antro Ingot"),
	inventory_image = "antro_ore_ingot.png",
})

--Define antro_ore Smelt Recipe
minetest.register_craft({
	type = "cooking",
	output = "antro_ore:antro_ore_ingot",
	recipe = "antro_ore:antro_ore_block",
	cooktime = 10,
})


--Make Antro   Ore spawn
local spawn_within = minetest.settings:get("antro_ore.spawn_within") or "default:stone"
minetest.log("action", "[antro_ore] ore set to spawn within " .. spawn_within
	.. ", this can be changed with antro_ore.spawn_within setting")

minetest.register_on_mods_loaded(function()
	if minetest.registered_nodes[spawn_within] then
		minetest.register_ore({
			ore_type = "scatter",
			ore = "antro_ore:antro_ore_block",
			wherein = spawn_within,
			clust_scarcity = 17*17*17,
			clust_num_ores = 3,
			clust_size = 3,
			y_min = -31000,
			y_max = -400,
		})
	else
		minetest.log("warning", "[antro_ore] " .. spawn_within .. " is not a registered node, Antro   ore will not spawn")
	end
end)
