minetest.register_node("moonstone:moonstone_block", {
	description = ("Moonstone"),
	tiles = {"moonstone_block.png"},
	groups = {stone=2, cracky=3.4},
	drop = "moonstone:moonstone_block",
	is_ground_content = true,
})

--Define moonstone_Ingot node
minetest.register_craftitem("moonstone:moonstone_ingot", {
	description = ("Moonstone Ingot"),
	inventory_image = "moonstone_ingot.png",
})

minetest.register_craft({
	output = "moonstone:moonstone_ingot 4",
	recipe = {
		{"antro_ore:antro_ore_ingot", "antro_ore:antro_ore_ingot", "antro_ore:antro_ore_ingot"},
		{"antro_ore:antro_ore_ingot", "sintain_ruby:sintain_ruby", "antro_ore:antro_ore_ingot"},
		{"antro_ore:antro_ore_ingot", "antro_ore:antro_ore_ingot", "antro_ore:antro_ore_ingot"},
	}
})

minetest.register_tool("moonstone:moonstone_boots", {
	description = ("Moonstone Boots"),
	inventory_image = "moonstone_boots_inv.png",
	groups = {armor_feet=12, armor_heal=0, armor_use=80},
	wear = 0,
})
 
--Make Moonstone spawn
local spawn_within = minetest.settings:get("moonstone.spawn_within") or "default:stone"
minetest.log("action", "[moonstone] ore set to spawn within " .. spawn_within
	.. ", this can be changed with moonstone.spawn_within setting")

minetest.register_on_mods_loaded(function()
	if minetest.registered_nodes[spawn_within] then
		minetest.register_ore({
			ore_type = "scatter",
			ore = "moonstone:moonstone_block",
			wherein = spawn_within,
			clust_scarcity = 17*17*17,
			clust_num_ores = 3,
			clust_size = 3,
			y_min = -31000,
			y_max = -600,
		})
	else
		minetest.log("warning", "[moonstone] " .. spawn_within .. " is not a registered node, Moonstone will not spawn")
	end
end)
