minetest.register_node("red_steel:red_steel_block", {
	description = ("Red Steel Ore"),
	tiles = {"red_steel_block.png"},
	groups = {stone=2, cracky=3},
	drop = "red_steel:red_steel_block",
	is_ground_content = true,
})

--Define red_steel_Ingot
minetest.register_craftitem("red_steel:red_steel_ingot", {
	description = ("Red Steel Ingot"),
	inventory_image = "red_steel_ingot.png",
})

--Define red_steel Smelt Recipe
minetest.register_craft({
	type = "cooking",
	output = "red_steel:red_steel_ingot",
	recipe = "red_steel:red_steel_block",
	cooktime = 10,
})


--Register Red Steel Pickaxe
minetest.register_tool("red_steel:red_steel_pickaxe", {
	description = ("Red Steel Pickaxe"),
	inventory_image = "red_steel_pickaxe.png",
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level=3,
		groupcaps={
			cracky = {times={[1]=2.0, [2]=0.5, [3]=0.25}, uses=15, maxlevel=3},
		},
		damage_groups = {fleshy=5},
	},
})


local stick = minetest.settings:get("red_steel.stick")
if not stick then
	if minetest.registered_items["default:stick"] then
		stick = "default:stick"
	else
		stick = "red_steel:red_steel_ingot"
	end
end

--Define red_steel_Pickaxe crafting recipe
minetest.register_craft({
	output = "red_steel:red_steel_pickaxe",
	recipe = {
		{"red_steel:red_steel_ingot", "red_steel:red_steel_ingot", "red_steel:red_steel_ingot"},
		{"", stick, ""},
		{"", stick, ""}
	}
})


--Register Red Steel Axe
minetest.register_tool("red_steel:red_steel_axe", {
	description = ("Red Steel Axe"),
	inventory_image = "red_steel_axe.png",
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level=3,
		groupcaps={
			choppy={times={[1]=1.05, [2]=0.45, [3]=0.25}, uses=15, maxlevel=3},
		},
		damage_groups = {fleshy=5},
	}
})


--Define Red Steel Axe crafting recipe
minetest.register_craft({
	output = "red_steel:red_steel_axe",
	recipe = {
		{"red_steel:red_steel_ingot", "red_steel:red_steel_ingot", ""},
		{"red_steel:red_steel_ingot", stick, ""},
		{"", stick, ""}
	}
})

minetest.register_craft({
	output = "red_steel:red_steel_axe",
	recipe = {
		{"", "red_steel:red_steel_ingot", "red_steel:red_steel_ingot"},
		{"", stick, "red_steel:red_steel_ingot"},
		{"", stick, ""}
	}
})


--Register Red Steel shovel
minetest.register_tool("red_steel:red_steel_shovel", {
	description = ("Red Steel Shovel"),
	inventory_image = "red_steel_shovel.png",
	wield_image = "red_steel_shovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=3,
		groupcaps={
			crumbly = {times={[1]=0.55, [2]=0.25, [3]=0.15}, uses=15, maxlevel=3},
		},
		damage_groups = {fleshy=2},
	},
})


--Define Red Steel shovel crafting recipe
minetest.register_craft({
	output = "red_steel:red_steel_shovel",
	recipe = {
		{"", "red_steel:red_steel_ingot", ""},
		{"", stick, ""},
		{"", stick, ""}
	}
})


--Register Red Steel sword
minetest.register_tool("red_steel:red_steel_sword", {
	description = ("Red Steel Sword"),
	inventory_image = "red_steel_sword.png",
	tool_capabilities = {
		full_punch_interval = 0.5,
		max_drop_level=3,
		groupcaps={
			snappy={times={[1]=0.95, [2]=0.45, [3]=0.15}, uses=20, maxlevel=3},
		},
		damage_groups = {fleshy=6},
	}
})


--Define Red Steel sword crafting recipe
minetest.register_craft({
	output = "red_steel:red_steel_sword",
	recipe = {
		{"", "red_steel:red_steel_ingot", ""},
		{"", "red_steel:red_steel_ingot", ""},
		{"", stick, ""}
	}
})

--Make Red Steel Ore spawn
local spawn_within = minetest.settings:get("red_steel.spawn_within") or "default:stone"
minetest.log("action", "[red_steel] ore set to spawn within " .. spawn_within
	.. ", this can be changed with red_steel.spawn_within setting")

minetest.register_on_mods_loaded(function()
	if minetest.registered_nodes[spawn_within] then
		minetest.register_ore({
			ore_type = "scatter",
			ore = "red_steel:red_steel_block",
			wherein = spawn_within,
			clust_scarcity = 17*17*17,
			clust_num_ores = 3,
			clust_size = 3,
			y_min = -31000,
			y_max = -400,
		})
	else
		minetest.log("warning", "[red_steel] " .. spawn_within .. " is not a registered node, Red Steel ore will not spawn")
	end
end)
