-- ctf_ranged/wep_defns.lua


--[[
   Tier 1:
   - pistol: ctf_ranged:makarov
   - DMR: ctf_ranged:mini14
   - Shotgun: ctf_ranged:remington870
   - SMG: ctf_ranged:thompson
   - Rifle: ctf_ranged:ak47
   - HMG: ctf_ranged:rpk
   Tier 2:
   - pistol: ctf_ranged:glock17
   - DMR: ctf_ranged:svd
   - Shotgun: ctf_ranged:benelli
   - SMG: ctf_ranged:uzi
   - Rifle: ctf_ranged:m16
   - HMG: ctf_ranged:m60
   Tier 3:
   - pistol: ctf_ranged:deagle
   - DMR: ctf_ranged:m200
   - Shotgun: ctf_ranged:jackhammer
   - SMG: ctf_ranged:mp5
   - Rifle: ctf_ranged:scar
   - HMG: ctf_ranged:minigun
   Energy weapons:
   - E: ctf_ranged:energy_pistol
   - E: ctf_ranged:energy_rifle
   - E: ctf_ranged:energy_shotgun

]]--


--------------------------
-- Tier 1
--------------------------
ctf_ranged.simple_register_gun("ctf_ranged:pistol", {
	type = "pistol",
	description = "Pistol",
	texture = "ctf_ranged_pistol.png",
	fire_sound = "ctf_ranged_pistol",
	rounds = 75,
	range = 75,
	damage = 2,
	automatic = true,
	fire_interval = 0.6,
	liquid_travel_dist = 2
})

ctf_ranged.simple_register_gun("ctf_ranged:rifle", {
	type = "rifle",
	description = "Rifle",
	texture = "ctf_ranged_rifle.png",
	fire_sound = "ctf_ranged_rifle",
	rounds = 40,
	range = 150,
	damage = 4,
	fire_interval = 0.8,
	liquid_travel_dist = 4,
})

ctf_ranged.simple_register_gun("ctf_ranged:shotgun", {
	type = "shotgun",
	description = "Shotgun",
	texture = "ctf_ranged_shotgun.png",
	fire_sound = "ctf_ranged_shotgun",
	bullet = {
		amount = 28,
		spread = 4,
	},
	rounds = 10,
	range = 24,
	damage = 1,
	fire_interval = 2,
})

ctf_ranged.simple_register_gun("ctf_ranged:smg", {
	type = "smg",
	description = "Submachinegun",
	texture = "ctf_ranged_smgun.png",
	fire_sound = "ctf_ranged_pistol",
	bullet = {
		spread = 2,
	},
	automatic = true,
	rounds = 36,
	range = 75,
	damage = 1,
	fire_interval = 0.1,
	liquid_travel_dist = 2,
})
