minetest.register_node("nimong:nimong_ore", {
	description = ("Nimong Ore"),
	tiles = {"nimong_ore.png"},
	groups = {stone=3, cracky=4},
	drop = "nimong:nimong_lump",
	is_ground_content = true,
})

--Define nimong_lump
minetest.register_craftitem("nimong:nimong_lump", {
	description = ("Nimong Lump"),
	type = "fuel",
        burntime = 55,
	inventory_image = "nimong_lump.png",
})

--Make Nimong Ore spawn
local spawn_within = minetest.settings:get("nimong.spawn_within") or "default:stone"
minetest.log("action", "[nimong] ore set to spawn within " .. spawn_within
	.. ", this can be changed with nimong.spawn_within setting")

minetest.register_on_mods_loaded(function()
	if minetest.registered_nodes[spawn_within] then
		minetest.register_ore({
			ore_type = "scatter",
			ore = "nimong:nimong_ore",
			wherein = spawn_within,
			clust_scarcity = 8.5*8.5*8.5,
			clust_num_ores = 3,
			clust_size = 5,
			y_min = -1000,
			y_max = -30,
		})
	else
		minetest.log("warning", "[nimong] " .. spawn_within .. " is not a registered node, Nimong ore will not spawn")
	end
end)
