minetest.register_node("sintain_ruby:sintain_ruby_block", {
	description = ("Sintain Ruby Ore"),
	tiles = {"sintain_ruby_block.png"},
	groups = {stone=2, cracky=3},
	drop = "sintain_ruby:sintain_ruby_block",
	is_ground_content = true,
})

--Define sintain_ruby_Ingot node
minetest.register_craftitem("sintain_ruby:sintain_ruby", {
	description = ("Sintain Ruby"),
	inventory_image = "sintain_ruby.png",
})





local stick = minetest.settings:get("sintain_ruby.stick")
if not stick then
	if minetest.registered_items["default:stick"] then
		stick = "default:stick"
	else
		stick = "sintain_ruby:sintain_ruby"
	end
end

--Make Sintain Ruby Ore spawn
local spawn_within = minetest.settings:get("sintain_ruby.spawn_within") or "default:stone"
minetest.log("action", "[sintain_ruby] ore set to spawn within " .. spawn_within
	.. ", this can be changed with sintain_ruby.spawn_within setting")

minetest.register_on_mods_loaded(function()
	if minetest.registered_nodes[spawn_within] then
		minetest.register_ore({
			ore_type = "scatter",
			ore = "sintain_ruby:sintain_ruby_block",
			wherein = spawn_within,
			clust_scarcity = 17*17*17,
			clust_num_ores = 3,
			clust_size = 3,
			y_min = -31000,
			y_max = -400,
		})
	else
		minetest.log("warning", "[sintain_ruby] " .. spawn_within .. " is not a registered node, Sintain Ruby ore will not spawn")
	end
end)
