
local S = mobs.intllib

local dirt_types = {

	{	nodes = {"ethereal:dry_dirt"},
		skins = {"default_grass.png"},
		drops = {
			{name = "ethereal:dry_dirt", chance = 1, min = 0, max = 2}
		}
	}
}


mobs:register_mob("epic_combat_sam:sam_", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 4,
	damage = 10,
	hp_min = 20,
	hp_max = 20,
	armor = 15,
	collisionbox = {-0.4, -1, -0.4, 0.4, 1.6, 0.4},
	visual = "mesh",
	mesh = "character.obj",
	textures = {
		{"character.png"},
	},
	blood_texture = "default_grass.png",
	makes_footstep_sound = true,
	sounds = {
		random = "mobs:sam_",
	},
	view_range = 20,
	walk_velocity = 2,
	run_velocity = 2,
	jump = true,
	drops = {
		{name = "default:mese_crystal", chance = 50, min = 0, max = 2},
	},
	water_damage = 1,
	lava_damage = 5,
	light_damage = 0,
	fear_height = 20,
	animation = {
		speed_normal = 15,
		speed_run = 15,
		stand_start = 0,
		stand_end = 14,
		walk_start = 15,
		walk_end = 38,
		run_start = 40,
		run_end = 63,
		punch_start = 40,
		punch_end = 63,
	},

	-- check surrounding nodes and spawn a specific monster
	on_spawn = function(self)

		local pos = self.object:get_pos() ; pos.y = pos.y - 1
		local tmp

		for n = 1, #dirt_types do

			tmp = dirt_types[n]

			if minetest.find_node_near(pos, 1, tmp.nodes) then

				self.base_texture = tmp.skins
				self.object:set_properties({textures = tmp.skins})

				if tmp.drops then
					self.drops = tmp.drops
				end

				return true
			end
		end

		return true -- run only once, false/nil runs every activation
	end
})


if not mobs.custom_spawn_monster then
mobs:spawn({
	name = "epic_combat_sam:sam_",
	nodes = {"default:dirt_with_grass", "ethereal:gray_dirt", "ethereal:dry_dirt"},
	min_light = 0,
	max_light = 7,
	chance = 500,
	active_object_count = 2,
	min_height = 0,
	day_toggle = false,
})
end


mobs:register_egg("epic_combat_sam:sam_", S("Sam"), "default_dirt.png", 1)


