--[[
Shooter Guns [shooter_guns]
Copyright (C) 2013-2019 stujones11, Stuart Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]--

shooter.register_weapon("shooter_guns:shotgun", {
	description = "Shotgun",
	inventory_image = "shooter_shotgun.png",
	spec = {
		user_knockback = 8,
		rounds = 12,
		range = 30,
		step = 15,
		shots = 15,
		spread = 10,
		tool_caps = {full_punch_interval=1.7, damage_groups={fleshy=2, ranged=1}},
		groups = {snappy=3, fleshy=3, oddly_breakable_by_hand=3},
		sounds = {
			shot = "shooter_shotgun",
		},
		bullet_image = "shooter_cap.png",
		particles = {
			amount = 8,
			minsize = 0.25,
			maxsize = 0.75,
		},
	},
})

shooter.register_weapon("shooter_guns:machine_gun", {
	description = "Machine Gun",
	inventory_image = "shooter_smgun.png",
	spec = {
		user_knockback = 1,
		rounds = 100,
		range = 160,
		step = 20,
		tool_caps = {full_punch_interval=0.2, damage_groups={fleshy=4, ranged=1}},
		groups = {snappy=3, fleshy=3, oddly_breakable_by_hand=3},
		sounds = {
			shot = "shooter_pistol",
		},
		bullet_image = "shooter_cap.png",
		particles = {
			amount = 4,
			minsize = 0.25,
			maxsize = 0.75,
		},
	},
})

minetest.register_craftitem("shooter_guns:ammo", {
	description = "Ammo",
	inventory_image = "shooter_ammo.png",
})


