local MODNAME = minetest.get_current_modname()

local function full_itemstring(stack)
    if stack:is_empty() then return "" end
    -- Includes name, count, wear, metadata if present
    return stack:to_string()
end

local function show_form(name, istr)
    local fs =
        "formspec_version[6]size[12,4]" ..
        "label[0.5,0.5;Full itemstring of your held item:]" ..
        "field[0.5,1.4;11,0.8;istr;Copy with Ctrl+C;" ..
            minetest.formspec_escape(istr) .. "]" ..
        "set_focus[istr;true]" ..
        "button_exit[5,3.0;2,0.9;close;Close]"
    minetest.show_formspec(name, MODNAME .. ":itemstring", fs)
end

local function cmd_func(name)
    local player = minetest.get_player_by_name(name)
    if not player then return false, "Player not found." end
    local stack = player:get_wielded_item()
    if stack:is_empty() then return false, "No item in hand." end
    local istr = full_itemstring(stack)
    show_form(name, istr)                 -- easy to copy via Ctrl+C
    minetest.chat_send_player(name, "[itemstring] " .. istr) -- also in chat
    return true, "Shown."
end

minetest.register_chatcommand("itemstring", {
    description = "Show full itemstring for the item in your hand",
    func = cmd_func,
})

minetest.register_chatcommand("is", {
    description = "Alias for /itemstring",
    func = cmd_func,
})

