local fart_radius = 16
local fart_sound = "sneak_fart_fart"

-- Known static-stage crops (extendable)
local crop_growth_stages = {
    farming_wheat = {"farming:wheat_1", "farming:wheat_2", "farming:wheat_3", "farming:wheat_4", "farming:wheat_5", "farming:wheat_6", "farming:wheat_7", "farming:wheat_8"},
    farming_carrot = {"farming:carrot_1", "farming:carrot_2", "farming:carrot_3"},
    farming_potato = {"farming:potato_1", "farming:potato_2", "farming:potato_3"},
    farming_cotton = {"farming:cotton_1", "farming:cotton_2", "farming:cotton_3", "farming:cotton_4", "farming:cotton_5", "farming:cotton_6", "farming:cotton_7", "farming:cotton_8"},
    farming_tomato = {"farming:tomato_1", "farming:tomato_2", "farming:tomato_3", "farming:tomato_4"},
}

-- Get next crop stage
local function get_next_growth_stage(name)
    for _, stages in pairs(crop_growth_stages) do
        for i, stage in ipairs(stages) do
            if stage == name and i < #stages then
                return stages[i + 1]
            end
        end
    end
    return nil
end

-- Track sneak state
local player_sneak_state = {}

minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local name = player:get_player_name()
        local ctrl = player:get_player_control()
        local was_sneaking = player_sneak_state[name] or false
        local is_sneaking = ctrl.sneak

        if is_sneaking and not was_sneaking then
            local pos = vector.round(player:get_pos())
            pos.y = pos.y + 0.5

            -- Fart sound
            for _, other in ipairs(minetest.get_connected_players()) do
                if vector.distance(pos, other:get_pos()) <= fart_radius then
                    minetest.sound_play(fart_sound, {
                        to_player = other:get_player_name(),
                        pos = pos,
                        max_hear_distance = fart_radius,
                        gain = 1.0,
                        pitch = math.random(80, 120) / 100,
                    })
                end
            end

            -- Fart cloud particles
            minetest.add_particlespawner({
                amount = 30,
                time = 0.4,
                minpos = {x=pos.x-0.5, y=pos.y, z=pos.z-0.5},
                maxpos = {x=pos.x+0.5, y=pos.y+0.2, z=pos.z+0.5},
                minvel = {x=-0.8, y=0.1, z=-0.8},
                maxvel = {x=0.8, y=0.4, z=0.8},
                minacc = {x=0, y=0.05, z=0},
                maxacc = {x=0, y=0.1, z=0},
                minexptime = 0.6,
                maxexptime = 1.2,
                minsize = 1.5,
                maxsize = 3.0,
                texture = "smoke_puff.png^[colorize:#00ff00:180",
                glow = 2,
            })

            -- Crop fertilization (hybrid)
            for dx = -2, 2 do
                for dz = -2, 2 do
                    local check_pos = {x = pos.x + dx, y = pos.y - 1, z = pos.z + dz}
                    local node = minetest.get_node(check_pos)
                    local def = minetest.registered_nodes[node.name]

                    -- If stage-based crop, grow next stage
                    local next_stage = get_next_growth_stage(node.name)
                    if next_stage then
                        minetest.set_node(check_pos, {name = next_stage})
                    elseif def and def.on_timer then
                        -- Trigger dynamic crop growth via on_timer
                        minetest.get_node_timer(check_pos):start(0.1)
                    end
                end
            end

            -- Reduce hunger via stamina mod if available
            if stamina and stamina.change_saturation then
                stamina.change_saturation(player, -1)
            end
        end

        player_sneak_state[name] = is_sneaking
    end
end)
