local special_dragon_names = {
    ["Keallach"] = { health_bonus = 215, damage_bonus = 12, speed_bonus = 4, effect = "powerful" },
    ["Ceardach"] = { health_bonus = 200, damage_bonus = 10, speed_bonus = 3, effect = "powerful" },
    ["Gillean"] = { health_bonus = 240, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Aon-Adharc"] = { health_bonus = 220, damage_bonus = 13, speed_bonus = 4, effect = "powerful" },
    ["Glenfinnan"] = { health_bonus = 210, damage_bonus = 11, speed_bonus = 4, effect = "powerful" },
    ["Tasglann"] = { health_bonus = 230, damage_bonus = 13, speed_bonus = 3, effect = "powerful" },
    ["Breannan"] = { health_bonus = 225, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Teine"] = { health_bonus = 235, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Deighean"] = { health_bonus = 200, damage_bonus = 11, speed_bonus = 4, effect = "powerful" },
    ["Kearnach"] = { health_bonus = 240, damage_bonus = 15, speed_bonus = 3, effect = "powerful" },
    ["Teannarach"] = { health_bonus = 210, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Creagneach"] = { health_bonus = 250, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Cridheach-Teine"] = { health_bonus = 225, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Deanach"] = { health_bonus = 205, damage_bonus = 10, speed_bonus = 4, effect = "powerful" },
    ["Teanndraigh"] = { health_bonus = 230, damage_bonus = 13, speed_bonus = 3, effect = "powerful" },
    ["Gleanach"] = { health_bonus = 240, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Kirnach"] = { health_bonus = 210, damage_bonus = 11, speed_bonus = 4, effect = "powerful" },
    ["Tearlach"] = { health_bonus = 250, damage_bonus = 15, speed_bonus = 3, effect = "powerful" },
    ["Dreaghal"] = { health_bonus = 230, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Galarach"] = { health_bonus = 215, damage_bonus = 10, speed_bonus = 4, effect = "powerful" },
    ["Draighean"] = { health_bonus = 220, damage_bonus = 13, speed_bonus = 3, effect = "powerful" },
    ["Cailleach"] = { health_bonus = 205, damage_bonus = 11, speed_bonus = 4, effect = "powerful" },
    ["Aonach"] = { health_bonus = 240, damage_bonus = 15, speed_bonus = 3, effect = "powerful" },
    ["Creagach"] = { health_bonus = 225, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Braonach"] = { health_bonus = 235, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Teathnach"] = { health_bonus = 200, damage_bonus = 10, speed_bonus = 4, effect = "powerful" },
    ["Dreaganach"] = { health_bonus = 250, damage_bonus = 15, speed_bonus = 4, effect = "powerful" },
    ["Cranach"] = { health_bonus = 210, damage_bonus = 11, speed_bonus = 3, effect = "powerful" },
    ["Teangach"] = { health_bonus = 230, damage_bonus = 13, speed_bonus = 4, effect = "powerful" },
    ["Dallachan"] = { health_bonus = 205, damage_bonus = 10, speed_bonus = 3, effect = "powerful" },
    ["Kaldallan"] = { health_bonus = 240, damage_bonus = 14, speed_bonus = 4, effect = "powerful" },
    ["Tarraingeach"] = { health_bonus = 220, damage_bonus = 12, speed_bonus = 3, effect = "powerful" },
    ["Keangalach"] = { health_bonus = 215, damage_bonus = 11, speed_bonus = 4, effect = "powerful" },
    ["Braethain"] = { health_bonus = 235, damage_bonus = 14, speed_bonus = 3, effect = "powerful" },
    ["Fionnach"] = { health_bonus = 250, damage_bonus = 15, speed_bonus = 3, effect = "powerful" },
    ["Caillteach"] = { health_bonus = 200, damage_bonus = 10, speed_bonus = 4, effect = "powerful" },
    ["Avalon"] = {
        health_bonus = 150,
        damage_bonus = 10,
        speed_bonus = 5,
        effect = "powerful"
    },
    ["Tarlochan"] = {
        health_bonus = 250,
        damage_bonus = 8,
        speed_bonus = 7,
        effect = "powerful"
    },
    ["Calleach"] = {
        health_bonus = 180,
        damage_bonus = 12,
        speed_bonus = 4,
        effect = "powerful"
    },
    ["Kilgara"] = {
        health_bonus = 250,
        damage_bonus = 15,
        speed_bonus = 4,
        effect = "powerful"
    },
    ["Cridheach-Uisge"] = {
        health_bonus = 200,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Leacach"] = {
        health_bonus = 170,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Albannach"] = {
        health_bonus = 200,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Loch Nis"] = {
        health_bonus = 200,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Rannoch"] = {
        health_bonus = 190,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Kerran"] = {
        health_bonus = 210,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Dealanach"] = {
        health_bonus = 220,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Deaglan"] = {
        health_bonus = 200,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },
    ["Gleannach"] = {
        health_bonus = 190,
        damage_bonus = 10,
        speed_bonus = 8,
        effect = "powerful"
    },

    -- Not very powerful names ..
    ["Suzie"] = {
        health_multiplier = 0.3, -- 30% от обычного здоровья
        damage_multiplier = 0.2, -- 20% от обычного урона
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["Susie"] = {
        health_multiplier = 0.3, -- 30% от обычного здоровья
        damage_multiplier = 0.2, -- 20% от обычного урона
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["suzie"] = {
        health_multiplier = 0.3, -- 30% от обычного здоровья
        damage_multiplier = 0.2, -- 20% от обычного урона
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["susie"] = {
        health_multiplier = 0.3, -- 30% от обычного здоровья
        damage_multiplier = 0.2, -- 20% от обычного урона
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["Bubbles"] = {
        health_multiplier = 0.35,
        damage_multiplier = 0.25,
        speed_multiplier = 0.45,
        effect = "cute"
    },
    ["Fishy"] = {
        health_multiplier = 0.25,
        damage_multiplier = 0.3,
        speed_multiplier = 0.35,
        effect = "cute"
    },
    ["Splashy"] = {
        health_multiplier = 0.4,
        damage_multiplier = 0.15,
        speed_multiplier = 0.5,
        effect = "cute"
    },
    ["Nemo"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.2,
        speed_multiplier = 0.45,
        effect = "cute"
    },
    ["Cutie"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.2,
        speed_multiplier = 0.45,
        effect = "cute"
    },
    ["Fluffy"] = {
        health_multiplier = 0.35,
        damage_multiplier = 0.3,
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["Ducky"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.2,
        speed_multiplier = 0.45,
        effect = "cute"
    },
    ["Waddles"] = {
        health_multiplier = 0.25,
        damage_multiplier = 0.3,
        speed_multiplier = 0.35,
        effect = "cute"
    },
    ["Puddle"] = {
        health_multiplier = 0.4,
        damage_multiplier = 0.2,
        speed_multiplier = 0.5,
        effect = "cute"
    },
    ["Pebble"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.25,
        speed_multiplier = 0.4,
        effect = "cute"
    },
    ["Snuggles"] = {
        health_multiplier = 0.35,
        damage_multiplier = 0.2,
        speed_multiplier = 0.45,
        effect = "cute"
    },
    ["Puffy"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.15,
        speed_multiplier = 0.5,
        effect = "cute"
    },
    ["Twinkle"] = {
        health_multiplier = 0.4,
        damage_multiplier = 0.3,
        speed_multiplier = 0.35,
        effect = "cute"
    },
    ["Tiny"] = {
        health_multiplier = 0.3,
        damage_multiplier = 0.2,
        speed_multiplier = 0.4,
        effect = "cute"
    }
}

function apply_name_bonuses(self)
    if not self or not self.nametag then return end

    -- Безопасно получаем модификаторы для имени
    local modifiers = special_dragon_names[self.nametag]
    if not modifiers then return end

    -- Проверяем тип эффекта и применяем соответствующие бонусы
    if modifiers.effect == "powerful" then
        -- Проверяем наличие всех необходимых полей
        self.max_health = (self.max_health or 1600) + (modifiers.health_bonus or 0)
        self.hp = self.max_health
        self.damage = (self.damage or 40) + (modifiers.damage_bonus or 0)
        self.speed = (self.speed or 50) + (modifiers.speed_bonus or 0)
    elseif modifiers.effect == "cute" then
        -- Используем безопасные множители с проверкой на nil
        self.max_health = math.floor(1600 * (modifiers.health_multiplier or 1))
        self.hp = self.max_health
        self.damage = math.floor(40 * (modifiers.damage_multiplier or 1))
        self.speed = math.floor(50 * (modifiers.speed_multiplier or 1))
        -- Безопасно устанавливаем размер
        self.growth_scale = (self.growth_scale or 1) * 0.7
        if self.set_scale then
            self:set_scale(self.growth_scale)
        end
    end

    -- Визуальные эффекты с проверками
    minetest.after(0.1, function()
        if not (self and self.object and self.object:get_pos()) then return end
        
        local pos = self.object:get_pos()
        if modifiers.effect == "powerful" then
            minetest.add_particlespawner({
                amount = 50,
                time = 1,
                minpos = vector.subtract(pos, 2),
                maxpos = vector.add(pos, 2),
                minvel = {x=-1, y=0, z=-1},
                maxvel = {x=1, y=2, z=1},
                minacc = {x=0, y=0.5, z=0},
                maxacc = {x=0, y=1, z=0},
                minexptime = 1,
                maxexptime = 2,
                minsize = 3,
                maxsize = 5,
                texture = "waterdragon_rare_water_particle_1.png",
                glow = 14
            })
        elseif modifiers.effect == "cute" then
            minetest.add_particlespawner({
                amount = 30,
                time = 1,
                minpos = vector.subtract(pos, 1),
                maxpos = vector.add(pos, 1),
                minvel = {x=-0.5, y=0, z=-0.5},
                maxvel = {x=0.5, y=1, z=0.5},
                minacc = {x=0, y=0.2, z=0},
                maxacc = {x=0, y=0.5, z=0},
                minexptime = 1,
                maxexptime = 2,
                minsize = 2,
                maxsize = 3,
                texture = "heart.png",
                glow = 8
            })
        end

        -- Безопасная отправка сообщений
        if self.owner then
            if modifiers.effect == "powerful" then
                minetest.chat_send_player(self.owner, "Your Dragon " .. self.nametag .. " feels powerful!")
            elseif modifiers.effect == "cute" then
                minetest.chat_send_player(self.owner, 
                    "Your Dragon " .. self.nametag .. 
                    " is adorable but very weak! You can better give him a more powerful name such as Braonach or Kirnach")
            end
        end
    end)

    -- Изменяем звуки для милых драконов с проверкой
    if modifiers.effect == "cute" and self.sounds then
        self.sounds.random = {
            {name = "waterdragon_water_dragon_child_1", gain = 0.7, distance = 32},
            {name = "waterdragon_water_dragon_child_2", gain = 0.7, distance = 32}
        }
    end
end
