# Zoonami Translations

Zoonami uses the newer Gettext (.po and .pot) file format for translations. In order to view these translations in-game you must use Minetest/Luanti 5.10 or newer. Older versions do not support the Gettext file format.

## How to contribute
* All contributions must be licensed under the [Creative Commons Zero (CC0)](http://creativecommons.org/publicdomain/zero/1.0/legalcode) license. While this license does not require credit to be given to contributors, an effort will be made to credit contributors below if you would like to be credited.
* Computer generated translations are not allowed. These tools often produce poor translations and might have restrictions that are incompatible with [Creative Commons Zero (CC0)](http://creativecommons.org/publicdomain/zero/1.0/legalcode) licensing.
* First start by finding the language code for the language you want to translate Zoonami to. You can find a list of codes by opening up Minetest/Luanti and going to Settings > Accessibility > Language. The language codes are listed in square brackets. 
* Next, open up the "locale" folder in the Zoonami mod. Inside you will find a file named `zoonami.pot` and potentially other files named `zoonami.LANGUAGE_CODE.po`. If you don't see a file with your language code, create a copy of the `zoonami.pot` file and rename it to `zoonami.LANGUAGE_CODE.po`.
* At this point, you will have to decide what tool you want to use to edit the `zoonami.LANGUAGE_CODE.po` file. You could use a simple text editor or program like Poedit.
* You do not need to translate the entire file. Partial translations are allowed.
* Pay attention to the translation comments. There are a few things, such as move names, that have special restrictions, such as character length limits. You'll have to work around these limitations.
* When finished, you can either [open an issue](https://codeberg.org/isaiah658/zoonami/issues) or leave a comment on the [Zoonami forum topic](https://forum.luanti.org/viewtopic.php?t=25356) linking to your changes.

## Contributors
* No contributors (yet)