-- Translations
local S = core.get_translator("zoonami")

-- Berries and Jelly
local function register_berry(berry_name, basic_name, improved_name, advanced_name, asset_name)
	core.register_craftitem("zoonami:"..asset_name.."_berry", {
		description = berry_name,
		inventory_image = "zoonami_"..asset_name.."_berry.png",
	})
	core.register_craftitem("zoonami:basic_"..asset_name.."_jelly", {
		description = basic_name,
		inventory_image = "zoonami_basic_"..asset_name.."_jelly.png",
	})
	core.register_craftitem("zoonami:improved_"..asset_name.."_jelly", {
		description = improved_name,
		inventory_image = "zoonami_improved_"..asset_name.."_jelly.png",
	})
	core.register_craftitem("zoonami:advanced_"..asset_name.."_jelly", {
		description = advanced_name,
		inventory_image = "zoonami_advanced_"..asset_name.."_jelly.png",
	})
end

-- Berries
register_berry(S("Blue Berry"), S("Basic Blue Jelly"), S("Improved Blue Jelly"), S("Advanced Blue Jelly"), "blue")
register_berry(S("Red Berry"), S("Basic Red Jelly"), S("Improved Red Jelly"), S("Advanced Red Jelly"), "red")
register_berry(S("Orange Berry"), S("Basic Orange Jelly"), S("Improved Orange Jelly"), S("Advanced Orange Jelly"), "orange")
register_berry(S("Green Berry"), S("Basic Green Jelly"), S("Improved Green Jelly"), S("Advanced Green Jelly"), "green")

-- Golden Jelly
core.register_craftitem("zoonami:golden_jelly", {
	description = S("Golden Jelly"),
	inventory_image = "zoonami_golden_jelly.png",
})

-- Sanded Plank
core.register_craftitem("zoonami:sanded_plank", {
	description = S("Sanded Plank"),
	inventory_image = "zoonami_sanded_plank.png",
	groups = {flammable = 3},
})

-- Stick
core.register_craftitem("zoonami:stick", {
	description = S("Stick"),
	inventory_image = "zoonami_stick.png",
	groups = {stick = 1, flammable = 2},
})

-- Cloth
core.register_craftitem("zoonami:cloth", {
	description = S("Cloth"),
	inventory_image = "zoonami_cloth.png",
	groups = {flammable = 3},
})

-- Paper
core.register_craftitem("zoonami:paper", {
	description = S("Paper"),
	inventory_image = "zoonami_paper.png",
	groups = {flammable = 3},
})

-- Zeenite Lump
core.register_craftitem("zoonami:zeenite_lump", {
	description = S("Zeenite Lump"),
	inventory_image = "zoonami_zeenite_lump.png"
})

-- Zeenite Ingot
core.register_craftitem("zoonami:zeenite_ingot", {
	description = S("Zeenite Ingot"),
	inventory_image = "zoonami_zeenite_ingot.png"
})

-- Crystal Fragment
core.register_craftitem("zoonami:crystal_fragment", {
	description = S("Crystal Fragment"),
	inventory_image = "zoonami_crystal_fragment.png",
})

-- Empty Pail
core.register_craftitem("zoonami:pail_empty", {
	description = S("Empty Pail"),
	inventory_image = "zoonami_pail_empty.png",
	liquids_pointable = true,
	stack_max = 1,
	on_place = function(itemstack, user, pointed_thing)
		if not user or not user:is_player() then return end
		local pos = pointed_thing.under
		local node = core.get_node(pos)
		local player_name = user:get_player_name()
		local inv = user:get_inventory()
		local node = core.get_node_or_nil(pointed_thing.under)
		local def = node and core.registered_nodes[node.name] or {}
		if core.is_protected(pos, player_name) then
			return
		elseif def.on_rightclick then
			return def.on_rightclick(pointed_thing.under, node, user, itemstack)
		elseif node.name == "zoonami:crystal_water_source" then
			core.sound_play("zoonami_water_footstep", {to_player = player_name, gain = 0.8}, true)
			core.set_node(pos, {name = "air"})
			return ItemStack("zoonami:pail_crystal_water")
		end
	end,
})

-- Crystal Water Pail
core.register_craftitem("zoonami:pail_crystal_water", {
	description = S("Crystal Water Pail"),
	inventory_image = "zoonami_pail_crystal_water.png",
	liquids_pointable = true,
	stack_max = 1,
	on_place = function(itemstack, user, pointed_thing)
		if not user or not user:is_player() then return end
		local player_name = user:get_player_name()
		local inv = user:get_inventory()
		local node = core.get_node_or_nil(pointed_thing.under)
		local def = node and core.registered_nodes[node.name] or {}
		local pos = def.buildable_to and pointed_thing.under or pointed_thing.above
		if core.is_protected(pos, player_name) then
			return
		elseif def.on_rightclick and not user:get_player_control().sneak then
			return def.on_rightclick(pointed_thing.under, node, user, itemstack)
		elseif pointed_thing.type == "node" then
			core.sound_play("zoonami_water_footstep", {to_player = player_name, gain = 0.8}, true)
			core.set_node(pos, {name = "zoonami:crystal_water_source"})
			return ItemStack("zoonami:pail_empty")
		end
	end,
})

-- Prism
core.register_craftitem("zoonami:prism", {
	description = S("Prism"),
	inventory_image = "zoonami_prism.png",
	on_use = function(itemstack, user, pointed_thing)
		if not user or not user:is_player() or pointed_thing.type ~= "object" then return end
		local player_name = user:get_player_name()
		local obj = pointed_thing.ref
		local self = obj and obj:get_luaentity() or {}
		if self.name:find('zoonami:') and self._type == "monster" and self._prisma_id then
			core.chat_send_player(player_name, S("Prisma Monster"))
		elseif self.name:find('zoonami:') and self._type == "monster" then
			core.chat_send_player(player_name, S("Normal Monster"))
		end
	end,
})

-- Coins
local function register_coin(name, asset_name, value)
	core.register_craftitem("zoonami:"..asset_name, {
		description = name,
		inventory_image = "zoonami_"..asset_name..".png",
		on_secondary_use = function (itemstack, user, pointed_thing)
			if not user or not user:is_player() then return end
			local name = user:get_player_name()
			local meta = user:get_meta()
			local current_zc = meta:get_int("zoonami_coins")
			local deposit_zc = itemstack:get_count() * value
			meta:set_int("zoonami_coins", current_zc + deposit_zc)
			core.sound_play("zoonami_coins", {to_player = name, gain = 0.9}, true)
			core.log("action", name.." deposited "..deposit_zc.." ZC into their bank.")
			core.chat_send_player(name, S("@1 has been added to your bank.", deposit_zc.." ZC"))
			return ItemStack()
		end,
		on_place = function(itemstack, placer, pointed_thing)
			if not placer or not placer:is_player() then return end
			local node = core.get_node_or_nil(pointed_thing.under)
			local def = node and core.registered_nodes[node.name] or {}
			if def.on_rightclick then
				return def.on_rightclick(pointed_thing.under, node, placer, itemstack)
			else
				local name = placer:get_player_name()
				local meta = placer:get_meta()
				local current_zc = meta:get_int("zoonami_coins")
				local deposit_zc = itemstack:get_count() * value
				meta:set_int("zoonami_coins", current_zc + deposit_zc)
				core.sound_play("zoonami_coins", {to_player = name, gain = 0.9}, true)
				core.log("action", name.." deposited "..deposit_zc.." ZC into their bank.")
				core.chat_send_player(name, S("@1 has been added to your bank.", deposit_zc.." ZC"))
				return ItemStack()
			end
		end,
	})
end

-- Coins
register_coin(S("1 ZC Coin"), "1_zc_coin", 1)
register_coin(S("10 ZC Coin"), "10_zc_coin", 10)
register_coin(S("100 ZC Coin"), "100_zc_coin", 100)
register_coin(S("1000 ZC Coin"), "1000_zc_coin", 1000)
