local function get_layer(n)
    return n+y_axis.ores_offset
end

local lava_y_min_offset=-500;
local lava_y_min_offset_medium=-2000;
local lava_y_min_offset_huge=-8000;

--unnessary ores and other  gens have been removed

local deepslate_max = y_axis.deepslate_layer;
local deepslate_min = y_axis.lowest_y;

local copper_mod = core.get_modpath("mcl_copper")

local mg_name = core.get_mapgen_setting("mg_name")
local superflat = mg_name == "flat" and core.get_mapgen_setting("mcl_superflat_classic") == "true"

local mountains = {
	"ExtremeHills", "ExtremeHills_beach", "ExtremeHills_ocean", "ExtremeHills_deep_ocean", "ExtremeHills_underground",
	"ExtremeHills+", "ExtremeHills+_ocean", "ExtremeHills+_deep_ocean", "ExtremeHills+_underground",
	"ExtremeHillsM", "ExtremeHillsM_ocean", "ExtremeHillsM_deep_ocean", "ExtremeHillsM_underground",
}

local stonelike = {"mcl_core:stone", "mcl_core:diorite", "mcl_core:andesite", "mcl_core:granite"}


-- Gravel
core.register_ore({
	ore_type       = "blob",
	ore            = "mcl_core:gravel",
	wherein        = stonelike,
	clust_scarcity = 14*14*14,
	clust_num_ores = 33,
	clust_size     = 5,
	y_min          = y_axis.lowest_y,
	y_max          = get_layer(111),
	noise_params = {
		offset  = 0,
		scale   = 1,
		spread  = {x=250, y=250, z=250},
		seed    = 12345,
		octaves = 3,
		persist = 0.6,
		lacunarity = 2,
		flags = "defaults",
	}
})


core.register_ore({
	ore_type       = "blob",
	ore            = "mcl_deepslate:tuff",
	wherein        = { "mcl_core:stone", "mcl_core:diorite",
                     "mcl_core:andesite", "mcl_core:granite", "mcl_deepslate:deepslate" },
	clust_scarcity = 10*10*10,
	clust_num_ores = 58,
	clust_size     = 7,
	y_min          = deepslate_min,
    y_max          = deepslate_max,
	noise_params = {
		offset  = 0,
		scale   = 1,
		spread  = {x=250, y=250, z=250},
		seed    = 12345,
		octaves = 3,
		persist = 0.6,
		lacunarity = 2,
		flags = "defaults",
	}
})

-- DEEPSLATE
if core.settings:get_bool("mcl_generate_deepslate", true) then

	core.register_ore({
		ore_type       = "blob",
		ore            = "mcl_deepslate:deepslate",
		wherein        = { "mcl_core:stone" },
		clust_scarcity = 200,
		clust_num_ores = 100,
		clust_size     = 10,
		y_min          = deepslate_min,
		y_max          = deepslate_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = { x = 250, y = 250, z = 250 },
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		}
	})

	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_deepslate:infested_deepslate",
		wherein        = "mcl_deepslate:deepslate",
		clust_scarcity = 26 * 26 * 26,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = deepslate_min,
		y_max          = deepslate_max,
		biomes         = mountains,
	})

	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:water_source",
		wherein        = "mcl_deepslate:deepslate",
		clust_scarcity = 9000,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = get_layer(5),
		y_max          = deepslate_max,
	})

	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:lava_source",
		wherein        = "mcl_deepslate:deepslate",
		clust_scarcity = 2000,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = get_layer(1),
		y_max          = get_layer(10),
	})

	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:lava_source",
		wherein        = "mcl_deepslate:deepslate",
		clust_scarcity = 9000,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = get_layer(11),
		y_max          = deepslate_max,
	})

end

if core.settings:get_bool("mcl_generate_ores", true) then
	--
	-- Coal
	--

	-- Common spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 525*3,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(50),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 510*3,
		clust_num_ores = 8,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(50),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 500*3,
		clust_num_ores = 12,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(50),
	})

	-- Medium-rare spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 550*3,
		clust_num_ores = 4,
		clust_size     = 2,
		y_min          = get_layer(51),
		y_max          = get_layer(80),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 525*3,
		clust_num_ores = 6,
		clust_size     = 3,
		y_min          = get_layer(51),
		y_max          = get_layer(80),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein        = stonelike,
		clust_scarcity = 500*3,
		clust_num_ores = 8,
		clust_size     = 3,
		y_min          = get_layer(51),
		y_max          = get_layer(80),
	})

	-- Rare spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein         = stonelike,
		clust_scarcity = 600*3,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = get_layer(81),
		y_max          = get_layer(128),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein         = stonelike,
		clust_scarcity = 550*3,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = get_layer(81),
		y_max          = get_layer(128),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_coal",
		wherein         = stonelike,
		clust_scarcity = 500*3,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = get_layer(81),
		y_max          = get_layer(128),
	})

	--
	-- Iron
	--
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_iron",
		wherein         = stonelike,
		clust_scarcity = 830,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(39),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_iron",
		wherein         = stonelike,
		clust_scarcity = 1660,
		clust_num_ores = 4,
		clust_size     = 2,
		y_min          = get_layer(40),
		y_max          = get_layer(63),
	})

	--
	-- Gold
	--

	-- Common spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_gold",
		wherein         = stonelike,
		clust_scarcity = 4775,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(30),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_gold",
		wherein         = stonelike,
		clust_scarcity = 6560,
		clust_num_ores = 7,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(30),
	})

	-- Rare spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_gold",
		wherein         = stonelike,
		clust_scarcity = 13000,
		clust_num_ores = 4,
		clust_size     = 2,
		y_min          = get_layer(31),
		y_max          = get_layer(33),
	})

	--
	-- Diamond
	--

	-- Common spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_diamond",
		wherein         = stonelike,
		clust_scarcity = 10000,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(12),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_diamond",
		wherein         = stonelike,
		clust_scarcity = 5000,
		clust_num_ores = 2,
		clust_size     = 2,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(12),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_diamond",
		wherein         = stonelike,
		clust_scarcity = 10000,
		clust_num_ores = 8,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(12),
	})

	-- Rare spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_diamond",
		wherein         = stonelike,
		clust_scarcity = 20000,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = get_layer(13),
		y_max          = get_layer(15),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_diamond",
		wherein         = stonelike,
		clust_scarcity = 20000,
		clust_num_ores = 2,
		clust_size     = 2,
		y_min          = get_layer(13),
		y_max          = get_layer(15),
	})

		--
	-- Ancient debris
	--
	local ancient_debris_wherein = {"mcl_nether:netherrack","mcl_blackstone:blackstone","mcl_blackstone:basalt"}
	-- Common spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:ancient_debris",
		wherein         = ancient_debris_wherein,
		clust_scarcity = 12000, -- MC would be 25000, MCLA uses 15000, needs balancing
		clust_num_ores = 3,
		clust_size     = 3,
		y_min = mcl_vars.mg_nether_min + 8,
		y_max = mcl_vars.mg_nether_min + 22,
	})
	--
	-- Redstone
	--

	-- Common spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_redstone",
		wherein         = stonelike,
		clust_scarcity = 500,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(13),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_redstone",
		wherein         = stonelike,
		clust_scarcity = 800,
		clust_num_ores = 7,
		clust_size     = 4,
		y_min          = y_axis.lowest_y,
		y_max          = get_layer(13),
	})

	-- Rare spawn
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_redstone",
		wherein         = stonelike,
		clust_scarcity = 1000,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = get_layer(13),
		y_max          = get_layer(15),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_redstone",
		wherein         = stonelike,
		clust_scarcity = 1600,
		clust_num_ores = 7,
		clust_size     = 4,
		y_min          = get_layer(13),
		y_max          = get_layer(15),
	})

	--
	-- Lapis Lazuli
	--

	-- Common spawn (in the center)
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 7000,
		clust_num_ores = 7,
		clust_size     = 4,
		y_min          = get_layer(14),
		y_max          = get_layer(16),
	})

	-- Rare spawn (below center)
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 10000,
		clust_num_ores = 6,
		clust_size     = 3,
		y_min          = get_layer(10),
		y_max          = get_layer(13),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 12000,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = get_layer(6),
		y_max          = get_layer(9),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 16000,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = get_layer(2),
		y_max          = get_layer(5),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 18000,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = get_layer(0),
		y_max          = get_layer(2),
	})

	-- Rare spawn (above center)
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 10000,
		clust_num_ores = 6,
		clust_size     = 3,
		y_min          = get_layer(17),
		y_max          = get_layer(20),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 12000,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = get_layer(21),
		y_max          = get_layer(24),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 14000,
		clust_num_ores = 4,
		clust_size     = 3,
		y_min          = get_layer(25),
		y_max          = get_layer(28),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 18000,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = get_layer(29),
		y_max          = get_layer(32),
	})
	core.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_lapis",
		wherein         = stonelike,
		clust_scarcity = 28000,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = get_layer(31),
		y_max          = get_layer(32),
	})

	if core.settings:get_bool("mcl_generate_deepslate", true) then
		local function register_ore_mg(ore, scarcity, num, size, y_min, y_max, biomes)
			core.register_ore({
				ore_type       = "scatter",
				ore            = ore,
				wherein        = { "mcl_deepslate:deepslate", "mcl_deepslate:tuff" },
				clust_scarcity = scarcity,
				clust_num_ores = num,
				clust_size     = size,
				y_min          = y_min,
				y_max          = y_max,
				biomes         = biomes,
			})
		end
		local ore_mapgen = {
			{ "coal", 1575, 5, 3, deepslate_min, deepslate_max },
			{ "coal", 1530, 8, 3, deepslate_min, deepslate_max },
			{ "coal", 1500, 12, 3, deepslate_min, deepslate_max },
			{ "iron", 830, 5, 3, deepslate_min, deepslate_max },
			{ "gold", 4775, 5, 3, deepslate_min, deepslate_max },
			{ "gold", 6560, 7, 3, deepslate_min, deepslate_max },
			{ "diamond", 10000, 4, 3, deepslate_min, get_layer(12) },
			{ "diamond", 5000, 2, 3, deepslate_min, get_layer(12) },
			{ "diamond", 10000, 8, 3, deepslate_min, get_layer(12) },
			{ "diamond", 20000, 1, 1, get_layer(13), get_layer(15) },
			{ "diamond", 20000, 2, 2, get_layer(13), get_layer(15) },
			{ "redstone", 500, 4, 3, deepslate_min, get_layer(13) },
			{ "redstone", 800, 7, 4, deepslate_min, get_layer(13) },
			{ "redstone", 1000, 4, 3, get_layer(13), get_layer(15) },
			{ "redstone", 1600, 7, 4, get_layer(13), get_layer(15) },
			{ "lapis", 10000, 7, 4, get_layer(14), deepslate_max },
			{ "lapis", 12000, 6, 3, get_layer(10), get_layer(13) },
			{ "lapis", 14000, 5, 3, get_layer(6), get_layer(9) },
			{ "lapis", 16000, 4, 3, get_layer(2), get_layer(5) },
			{ "lapis", 18000, 3, 2, get_layer(0), get_layer(2) },
		}
		for _, o in pairs(ore_mapgen) do
			register_ore_mg("mcl_deepslate:deepslate_with_"..o[1], o[2], o[3], o[4], o[5], o[6])
		end
		register_ore_mg("mcl_deepslate:deepslate_with_emerald", 16384, 1, 1, get_layer(4), deepslate_max, mountains)
		if copper_mod then
			register_ore_mg("mcl_deepslate:deepslate_with_copper", 830, 5, 3, deepslate_min, deepslate_max)
			core.register_ore({
				ore_type       = "scatter",
				ore            = "mcl_copper:stone_with_copper",
				wherein        = stonelike,
				clust_scarcity = 830,
				clust_num_ores = 5,
				clust_size     = 3,
				y_min          = y_axis.lowest_y,
				y_max          = get_layer(39),
			})
			core.register_ore({
				ore_type       = "scatter",
				ore            = "mcl_copper:stone_with_copper",
				wherein        = stonelike,
				clust_scarcity = 1660,
				clust_num_ores = 4,
				clust_size     = 2,
				y_min          = get_layer(40),
				y_max          = get_layer(63),
			})
		end
	end
end

if not superflat then
-- Water and lava springs (single blocks of lava/water source)
-- Water appears at nearly every height, but not near the bottom
core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:water_source",
	wherein         = {"mcl_core:stone", "mcl_core:andesite", "mcl_core:diorite", "mcl_core:granite", "mcl_core:dirt"},
	clust_scarcity = 9000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(5),
	y_max          = get_layer(128),
})

-- Lava springs are rather common at -31 and below
core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:lava_source",
	wherein         = stonelike,
	clust_scarcity = 2000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(1)+lava_y_min_offset_huge,
	y_max          = get_layer(10)+lava_y_min_offset_huge,
})

core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:lava_source",
	wherein         = stonelike,
	clust_scarcity = 9000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(11)+lava_y_min_offset_huge,
	y_max          = get_layer(31)+lava_y_min_offset_huge,
})

-- Lava springs will become gradually rarer with increasing height
core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:lava_source",
	wherein         = stonelike,
	clust_scarcity = 32000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(32)+lava_y_min_offset_medium,
	y_max          = get_layer(47)+lava_y_min_offset_medium,
})

core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:lava_source",
	wherein         = stonelike,
	clust_scarcity = 72000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(48)+lava_y_min_offset_medium,
	y_max          = get_layer(61)+lava_y_min_offset_medium,
})

-- Lava may even appear above surface, but this is very rare
core.register_ore({
	ore_type       = "scatter",
	ore            = "mcl_core:lava_source",
	wherein         = stonelike,
	clust_scarcity = 96000,
	clust_num_ores = 1,
	clust_size     = 1,
	y_min          = get_layer(62)+lava_y_min_offset,
	y_max          = get_layer(127)+lava_y_min_offset,
})
end
