local stronghold_depth = tonumber(core.settings:get("y_axis.stronghold_depth")) or -256

core.register_on_mods_loaded(function()
    if mcl_structures and mcl_structures.registered_structures then
        local stronghold_def = mcl_structures.registered_structures["end_shrine"]
        if stronghold_def and stronghold_def.static_pos then
            for i, pos in ipairs(stronghold_def.static_pos) do
                pos.y = stronghold_depth
            end
        else
            core.log("warning",
             "[my_stronghold_override] Could not find the 'end_shrine' structure or its static_pos list.")
        end
    else
        core.log("warning",
        "[my_stronghold_override] Could not find the 'mcl_structures' global table. Override failed.")
    end
end)
