mobs:register_mob("tmw_slimes:cloud_slime", {
	group_attack = true,
	type = "animal",
	passive = false,
	attack_animals = false,
	attack_npcs = false,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 6,
	hp_min = 35,
	hp_max = 45,
	armor = 100,
	yams_resists = {
		yams_light = {damage = -100, knockback = 0},
		yams_dark = {damage = 200, knockback = 100},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_liquid.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["cloud"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["cloud"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["cloud"].."^[colorize:#FFF:96"},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.75,
	run_velocity = 5,
	jump_height = 7,
	jump = true,
	view_range = 15,
	fly = true,
	fly_in = {"air", "default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = {
		{name = "tmw_slimes:cloud_goo", chance = 1, min = 1, max = 2},
	},
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	fall_damage = 0,
	animation = {
		idle_start = 0,
		idle_end = 19,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 400,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

minetest.override_item("tmw_slimes:cloud_goo", {on_use = minetest.item_eat(0)})

mobs:spawn({
	name = "tmw_slimes:cloud_slime",
	nodes = {
		"group:soil",
	},
	interval = 15,
	chance = 320000,
	min_height = 1024,
	max_height = 8190,
})
