local tmp_drops = {{name = "tmw_slimes:ocean_goo", chance = 1, min = 1, max = 2}}
if minetest.get_modpath("yams_materials") then
	table.insert(tmp_drops, {name = "yams_materials:water_essence", chance = 4, min = 1, max = 1})
end

mobs:register_mob("tmw_slimes:ocean_slime", {
	group_attack = true,
	type = "animal",
	passive = false,
	attack_animals = false,
	attack_npcs = false,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 3,
	hp_min = 18,
	hp_max = 22,
	armor = 100,
	yams_resists = {
		yams_fire = {damage = 0, knockback = 0},
		yams_ice = {damage = 50, knockback = 50},
		yams_electric = {damage = 200, knockback = 100},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_liquid.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["ocean"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["ocean"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["ocean"].."^[colorize:#FFF:96"},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 4,
	jump_height = 7,
	view_range = 48, --This thing will chase you all the way to shore.
	jump = true,
	fly = true,
	fly_in = {"default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = tmp_drops,
	water_damage = 0,
	lava_damage = 0,
	fire_damage = 0,
	light_damage = 0,
	fall_damage = 0,
	animation = {
		idle_start = 0,
		idle_end = 19,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 5,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

minetest.override_item("tmw_slimes:ocean_goo", {on_use = minetest.item_eat(1)})

mobs:spawn({
	name = "tmw_slimes:ocean_slime",
	nodes = {
		"default:water_source",
	},
	neighbors = {
		"default:water_source",
	},
	interval = 15,
	chance = 128000,
	min_height = -32,
	max_height = -8,
})
