local S = core.get_translator(core.get_current_modname())
local storage = core.get_mod_storage()

yams = {}

-- Taken from Mobs Redo
function yams.is_player(player)
    return player and type(player) == "userdata" and core.is_player(player)
end

-- Given a number, round up or down based on the fractional part of the number
function yams.round_with_fraction_as_probability(val)
    local floor_val = math.floor(val)
    local fraction = val - floor_val
    if fraction > 0 and math.random() <= fraction then
        return math.ceil(val)
    else
        return floor_val
    end
end

-- Warn the player if silver is disabled on a world in which it was enabled
local function silver_setting_check(playername)
    local was_enabled = storage:get_int("yams_base:was_silver_enabled")
    local silver_enabled = core.settings:get_bool("yams_enable_silver", false)

    if was_enabled == 1 and not silver_enabled then
        local msg = S("Warning: silver is disabled on a world that may " ..
                      "contain silver. Unknown nodes and items may be present.")
        msg = core.colorize("#ffff00", msg)
        core.chat_send_player(playername, msg)
    end

    if silver_enabled then
        core.chat_send_player(playername, S("Note: silver ore is enabled."))

        -- Allow a short delay for the player to realize that silver should not
        -- be enabled; ten seconds should be long enough for the player to
        -- realize the setting is wrong but short enough that it is unlikely
        -- that any silver generates unless players have noclip I guess
        core.after(10.0, function()
            storage:set_int("yams_base:was_silver_enabled", 1)
        end)
    end
end

local function login_message(player, last_login)
    local name = player:get_player_name()
    if last_login == nil then
        core.chat_send_player(name, S("Welcome to yams RPG! " ..
            "If this is your first time playing, make sure to read the help " ..
            "pages, which can be accessed within the More tab on the " ..
            "inventory screen."))
    else
        core.chat_send_player(name, S("Welcome back to yams RPG! " ..
            "Remember that you can read the help pages at any time by " ..
            "going to the More tab from within the inventory screen."))
    end

    if core.is_singleplayer() then
        silver_setting_check(name)
    end
end

core.register_on_joinplayer(login_message)

local function disable_debug(player, last_login)
    player:hud_set_flags({basic_debug = false})
end

core.register_on_joinplayer(disable_debug)

print("yams_base loaded")
