local S = core.get_translator(core.get_current_modname())

-- Only add if moreblocks is not present
if not core.get_modpath("moreblocks") then
    local dirt_sounds = default.node_sound_dirt_defaults()
    local stone_sounds = default.node_sound_stone_defaults()

    if core.get_modpath("sounds_redone") then
        local footstep_volume = tonumber(core.settings:get("footstep_vol")) or 0.1

        dirt_sounds = default.node_sound_dirt_defaults({
            footstep = {name = "dirt_footstep", gain = 0.1 + footstep_volume},
        })
        stone_sounds = default.node_sound_stone_defaults({
            footstep = {name = "stone_footstep", gain = 0.2 + footstep_volume},
        })
    end

    -- The ":" prefix is required since it's not really from this mod
    core.register_node(":moreblocks:dirt_compressed", {
        description = S("Compressed Dirt"),
        tiles = {"moreblocks_dirt_compressed.png"},
        groups = {crumbly = 2, compressed = 1},
        is_ground_content = false,
        sounds = default.node_sound_dirt_defaults(),
    })

    core.register_craft({
        output = "moreblocks:dirt_compressed",
        recipe = {
            {'default:dirt', 'default:dirt', 'default:dirt'},
            {'default:dirt', 'default:dirt', 'default:dirt'},
            {'default:dirt', 'default:dirt', 'default:dirt'},
        }
    })

    core.register_craft({
        output = "default:dirt 9",
        recipe = {{"moreblocks:dirt_compressed"}},
    })

    core.register_node(":moreblocks:cobble_compressed", {
        description = S("Compressed Cobblestone"),
        tiles = {"moreblocks_cobble_compressed.png"},
        groups = {cracky = 1, compressed = 1},
        is_ground_content = false,
        sounds = default.node_sound_stone_defaults(),
    })

    core.register_craft({
        output = "moreblocks:cobble_compressed",
        recipe = {
            {"default:cobble", "default:cobble", "default:cobble"},
            {"default:cobble", "default:cobble", "default:cobble"},
            {"default:cobble", "default:cobble", "default:cobble"},
        }
    })

    core.register_craft({
        output = "default:cobble 9",
        recipe = {
            {"moreblocks:cobble_compressed"},
        }
    })

    core.register_node(":moreblocks:desert_cobble_compressed", {
        description = S("Compressed Desert Cobblestone"),
        tiles = {"moreblocks_desert_cobble_compressed.png"},
        groups = {cracky = 1, compressed = 1},
        is_ground_content = false,
        sounds = default.node_sound_stone_defaults(),
    })

    core.register_craft({
        output = "moreblocks:desert_cobble_compressed",
        recipe = {
            {"default:desert_cobble", "default:desert_cobble", "default:desert_cobble"},
            {"default:desert_cobble", "default:desert_cobble", "default:desert_cobble"},
            {"default:desert_cobble", "default:desert_cobble", "default:desert_cobble"},
        }
    })

    core.register_craft({
        output = "default:desert_cobble 9",
        recipe = {
            {"moreblocks:desert_cobble_compressed"},
        }
    })
end

print("yams_compressed_blocks loaded")
