-- Obsidian wart

-- Taken from X Farming and adapted to yams

local S = core.get_translator(core.get_current_modname())

local MIN_LIGHT = 0
local MAX_LIGHT = 6

-- Basically a modified version of farming.place_seed
function seed_on_place(itemstack, placer, pointed_thing)
    if not placer or not core.is_player(placer) or not itemstack then
        return nil
    end

    if not pointed_thing or pointed_thing.type ~= "node" then
        return nil
    end

    local above = core.get_node(pointed_thing.above)
    local under = core.get_node(pointed_thing.under)

    -- Unknown node check
    if not core.registered_nodes[above.name] or
            not core.registered_nodes[under.name] then
        return nil
    end

    -- Nodes with on_rightclick have priority
    local under_def = core.registered_nodes[under.name]
    if under_def and under_def.on_rightclick then
        return def.on_rightclick(pointed_thing.under, under, placer, itemstack,
                                 pointed_thing)
    end

    -- Player must be pointing to the top of a node
    if pointed_thing.above.y ~= pointed_thing.under.y + 1 then
        return nil
    end

    -- Node must be replaceable
    if not core.registered_nodes[above.name].buildable_to then
        return nil
    end

    -- Obsidian wart seeds must be placed on these nether blocks
    if under.name ~= "nether:rack" and under.name ~= "nether:rack_deep" and
            under.name ~= "nether:sand" then
        return nil
    end

    -- Prevent multiple plant timers from occurring
    if core.get_item_group(above.name, "plant") ~= 0 then
        return nil
    end

    local placer_name = placer:get_player_name()

    -- Respect protection
    if core.is_protected(pointed_thing.above, placer_name) then
        core.record_protection_violation(pointed_thing.above, placer_name)
        return nil
    end

    core.set_node(pointed_thing.above, {
        name = "yams_farming:seed_obsidian_wart", param2 = 1
    })
    core.sound_play("default_place_node", {pos = pointed_thing.above, gain = 1.0})

    farming.start_seed_timer(pointed_thing.above)

    if not farming.is_creative(placer_name) then
        itemstack:take_item()
        -- Don't call farming.refill_plant on purpose
    end

    return itemstack
end

core.register_node("yams_farming:seed_obsidian_wart", {
    description = S("Obsidian Wart Seed"),
    tiles = {"x_farming_obsidian_wart_seed.png"},
    inventory_image = "x_farming_obsidian_wart_seed.png",
    wield_image = "x_farming_obsidian_wart_seed.png",
    drawtype = "signlike",
    -- Obsidian warts are resistant to fire
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              growing = 1},
    is_ground_content = false, 
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    next_plant = "yams_farming:obsidian_wart_1",
    minlight = MIN_LIGHT,
    maxlight = MAX_LIGHT,
    on_place = seed_on_place,
    on_timer = function(pos, elapsed)
        -- Only sprout in the dark
        local light = core.get_node_light(pos)
        if not light or light > MAX_LIGHT then
            farming.start_seed_timer(pos)
            return
        end
        
        core.set_node(pos, {name = "yams_farming:obsidian_wart_1", param2 = 3})
    end,
    _tt_help = S("Plant on netherrack or nethersand") .. "\n" ..
               S("Grows only in the dark") .. "\n" ..
               S("Does not require water"),
})

core.register_craftitem("yams_farming:obsidian_wart", {
    description = S("Obsidian Wart"),
    inventory_image = "x_farming_obsidian_wart.png",
    groups = {compostability = 65},
})

-- Check for netherrack or nethersand under the obsidian wart, and check if it
-- is dark enough for it to grow
function wart_growth_check(pos, node_name)
    local under = core.get_node({x = pos.x, y = pos.y - 1, z = pos.z})
    if under.name ~= "nether:rack" and under.name ~= "nether:rack_deep" and
            under.name ~= "nether:sand" then
        return false
    end

    local light = core.get_node_light(pos)
    if not light or light > MAX_LIGHT then
        return false
    end

    return true
end

local def = {
    description = S("Obsidian Wart Crop"),
    drawtype = "plantlike",
    tiles = {"x_farming_obsidian_wart_1.png"},
    paramtype = "light",
    paramtype2 = "meshoptions",
    place_param2 = 3,
    sunlight_propagates = true,
    waving = 1,
    walkable = false,
    buildable_to = true,
    drop = "",
    selection_box = farming.select,
    groups = {snappy = 3, plant = 1, attached_node = 1,
          not_in_creative_inventory = 1, growing = 1},
    minlight = 0,
    maxlight = 6,
    is_ground_content = false,
    sounds = farming.node_sound_leaves_defaults(),
    growth_check = wart_growth_check,
}

core.register_node("yams_farming:obsidian_wart_1", table.copy(def))

for i = 2, 6 do
    local x = tostring(i)
    def.tiles = {"x_farming_obsidian_wart_" .. x .. ".png"}
    core.register_node("yams_farming:obsidian_wart_" .. x, table.copy(def))
end

core.override_item("yams_farming:obsidian_wart_5", {
    drop = {
        items = {
            {rarity = 1, items = {"yams_farming:seed_obsidian_wart"}},
            {rarity = 1, items = {"yams_farming:obsidian_wart"}},
        }
    }
})

core.override_item("yams_farming:obsidian_wart_6", {
    drop = {
        items = {
            {rarity = 1, items = {"yams_farming:seed_obsidian_wart"}},
            {rarity = 2, items = {"yams_farming:seed_obsidian_wart"}},
            {rarity = 1, items = {"yams_farming:obsidian_wart"}},
            {rarity = 2, items = {"yams_farming:obsidian_wart"}},
        }
    }
})

-- This actually doesn't really do anything in Farming Redo; it's a
-- core.after() call in Farming Redo that assigns all the timer callbacks
-- However, the 'sickles' mod does read this data so it is best to set it
-- properly
farming.registered_plants["yams_farming:obsidian_wart"] = {
    crop = "yams_farming:obsidian_wart",
    seed = "yams_farming:seed_obsidian_wart",
    minlight = MIN_LIGHT,
    maxlight = MAX_LIGHT,
    steps = 6
}

-- Spawn obsidian wart in the nether
core.register_decoration({
    deco_type = "simple",
    place_on = {"nether:rack", "nether:rack_deep", "nether:sand"},
    sidelen = 16,
    noise_params = {
        offset = 0.0,
        scale = 0.005,
        spread = {x = 100, y = 100, z = 100},
        seed = 992,
        octaves = 3,
        persist = 0.7
    },
    y_min = -31000,
    y_max = -20000,
    decoration = "yams_farming:obsidian_wart_6"
})

if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"yams_farming:obsidian_wart_", 6, "yams_farming:seed_obsidian_wart"},
    })
end
