-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
	local res = {}

	if core.get_modpath("tnt") then
		table.insert(res, {name = "tnt:gunpowder", chance = 1, min = 1, max = 1})
	end

	if core.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:februm_crystal", chance = 2, min = 1, max = 1}
		)
	end

	if core.get_modpath("yams_materials") then
		table.insert(res,
			{name = "yams_materials:fire_essence", chance = 10, min = 1, max = 1}
		)
	end

	return res
end

-- Tree Monster (or Tree Gollum) by PilzAdam

mobs:register_mob("yams_mobs:explosion_master", {
	type = "monster",
	passive = false,
	attack_type = "explode",
	attack_animals = false,
	pathfinding = true,
	reach = 3,
	damage = 30,
	damage_max = 150,
	explosion_radius = 3,
	explosion_timer = 3,
	stop_to_explode = false,
	fuse_reset_range = 5,
	explosion_height_offset = -0.5,
	hp_min = 25,
	hp_max = 120,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "mobs_tree_monster.b3d",
	textures = {
		{"mobs_tree_monster6.png"}
	},
	makes_footstep_sound = true,
	sounds = {
		attack = "tnt_ignite",
		explode = "tnt_explode",
		fuse = "tnt_ignite"
	},
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	jump = true,
	view_range = 15,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	fear_height = 4,
	animation = {
		speed_normal = 15,
		speed_run = 15,
		stand_start = 0,
		stand_end = 24,
		walk_start = 25,
		walk_end = 47,
		run_start = 48,
		run_end = 62,
		punch_start = 48,
		punch_end = 62
	},
	base_exp = 1500,
	max_exp = 9000,
	yams_scaling_opts = {
		cavern_start = -1024,
		cavern_fast_until = -3072,
	},
	-- Fire attacks will make the mob explode almost instantly
	do_punch = function(self, hitter, tflp, toolcaps, dir)
		local elements = nil
		local is_player = hitter and type(hitter) == "userdata" and 
		                  core.is_player(hitter)

		if self._yams_hit_by_projectile then
			elements = self._yams_next_elements
		elseif is_player then
			local weapon = hitter:get_wielded_item()
			local def = core.registered_tools[weapon:get_name()]
			if def and def._yams_elements then
				elements = def._yams_elements
			end
		end
		
		if elements and elements.yams_fire then
			self.timer = 0  -- Reset the timer since it counts up when idle too
			self.v_start = true  -- Controls whether the mob is counting down
			self.explosion_timer = 1  -- Shorten the fuse
			self.allow_fuse_reset = false  -- No way of stopping it now
			self.stop_to_explode = true  -- Be fair to the player
			self:mob_sound(self.sounds.fuse)  -- Warn the player
		end
	end,
})


if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "yams_mobs:explosion_master",
		nodes = {"default:stone", "default:desert_stone", "default:sandstone",
		"default:sand", "default:desert_sand", "default:silver_sand",
		"default:ice", "caverealms:stone_with_moss",
		"caverealms:stone_with_lichen", "caverealms:stone_with_algae",
		"caverealms:stone_with_salt", "caverealms:hot_cobble",
		"caverealms:thin_ice", "caverealms:glow_obsidian",
		"caverealms:glow_obsidian_2", "caverealms:coal_dust"},
		max_light = 4,
		interval = 15,
		chance = 64000,
		min_height = -19990,
		max_height = -1024
	})
end


mobs:register_egg("yams_mobs:explosion_master", S("Explosion Master"), "default_tree_top.png", 1)
