
--[[
	Textures edited from:
	http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1288375-food-plus-mod-more-food-than-you-can-imagine-v2-9)
]]

local S = minetest.get_translator("farming")

-- item/seed

minetest.register_craftitem("farming:tomato", {
	description = S("Tomato"),
	inventory_image = "farming_tomato.png",
	groups = {compostability = 45, seed = 2, food_tomato = 1},
	on_use = minetest.item_eat(2),

	on_place = function(itemstack, placer, pointed_thing)
		return farming.place_seed(itemstack, placer, pointed_thing, "farming:tomato_1")
	end
})

farming.add_eatable("farming:tomato", 4)

-- crop definition

local def = {
	description = S("Tomato") .. S(" Crop"),
	drawtype = "plantlike",
	tiles = {"farming_tomato_1.png"},
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	drop = "",
	waving = 1,
	selection_box = farming.select,
	groups = {
		handy = 1, snappy = 3, flammable = 2, plant = 1, attached_node = 1,
		not_in_creative_inventory = 1, growing = 1
	},
	_mcl_hardness = farming.mcl_hardness,
	is_ground_content = false,
	sounds = farming.node_sound_leaves_defaults()
}

-- stage 1

minetest.register_node("farming:tomato_1", table.copy(def))

-- stage2

def.tiles = {"farming_tomato_2.png"}
minetest.register_node("farming:tomato_2", table.copy(def))

-- stage 3

def.tiles = {"farming_tomato_3.png"}
minetest.register_node("farming:tomato_3", table.copy(def))

-- stage 4

def.tiles = {"farming_tomato_4.png"}
minetest.register_node("farming:tomato_4", table.copy(def))

-- stage 5

def.tiles = {"farming_tomato_5.png"}
minetest.register_node("farming:tomato_5", table.copy(def))

-- stage 6

def.tiles = {"farming_tomato_6.png"}
minetest.register_node("farming:tomato_6", table.copy(def))

-- stage 7

def.tiles = {"farming_tomato_7.png"}
def.drop = {
	items = {
		{items = {"farming:tomato"}, rarity = 1},
		{items = {"farming:tomato"}, rarity = 3}
	}
}
minetest.register_node("farming:tomato_7", table.copy(def))

-- stage 8 (final)

def.tiles = {"farming_tomato_8.png"}
def.groups.growing = nil
def.selection_box = farming.select_final
def.drop = {
	items = {
		{items = {"farming:tomato 2"}, rarity = 1},
		{items = {"farming:tomato"}, rarity = 2},
		{items = {"farming:tomato"}, rarity = 3},
		{items = {"farming:tomato"}, rarity = 4}
	}
}
minetest.register_node("farming:tomato_8", table.copy(def))

-- add to registered_plants

farming.registered_plants["farming:tomato"] = {
	crop = "farming:tomato",
	seed = "farming:tomato",
	minlight = farming.min_light,
	maxlight = farming.max_light,
	steps = 8
}

-- mapgen

minetest.register_decoration({
	deco_type = "simple",
	place_on = {
		"default:dirt_with_grass", "mcl_core:dirt_with_grass",
		"ebiomes:dirt_with_grass_warm", "ebiomes:dirt_with_grass_cold",
		"ethereal:prairie_dirt"
	},
	sidelen = 16,
	noise_params = {
		offset = 0,
		scale = farming.tomato,
		spread = {x = 100, y = 100, z = 100},
		seed = 365,
		octaves = 3,
		persist = 0.7
	},
	-- Notes on the reasoning:
	-- * In yams, the tomato is a temperate plant and is exclusive to
	-- temperate biomes
	-- * Tropical biomes already have many other types of crops, and a fair
	-- amount of people would not think that tomato is a tropical plant
	-- * There are real-life varieties that can survive in the Andes, but they
	-- do not fit the winter biomes of yams very well
	-- * Many plants in real-life do not grow well in full shade, but we
	-- disregard that detail in yams since the average player will not notice,
	-- and this simplification benefits the gameplay; thus, tomatoes will also
	-- spawn in many types of forests
	biomes = {
		"grassland", "grassland_coldish", "grassland_warm", "deciduous_forest",
		"deciduous_forest_woody", "deciduous_forest_fruity",
		"deciduous_forest_cold", "deciduous_forest_warm"
	},
	y_min = 1,
	y_max = 64,
	decoration = "farming:tomato_7"
})
