--[[
	Mobs Ghost Redo - Adds ghosts.
	Copyright © 2018, 2019 Hamlet <hamlatmesehub@riseup.net> and contributors.

	Licensed under the EUPL, Version 1.2 or – as soon they will be
	approved by the European Commission – subsequent versions of the
	EUPL (the "Licence");
	You may not use this work except in compliance with the Licence.
	You may obtain a copy of the Licence at:

	https://joinup.ec.europa.eu/software/page/eupl
	https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:32017D0863

	Unless required by applicable law or agreed to in writing,
	software distributed under the Licence is distributed on an
	"AS IS" basis,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
	implied.
	See the Licence for the specific language governing permissions
	and limitations under the Licence.

--]]

-- Translation and settings

local S = minetest.get_translator("mobs_ghost_redo")
local ghost_daytime_check = minetest.settings:get_bool("mobs_ghost_redo_daytime_check")
local ghost_bones_only = minetest.settings:get_bool("mobs_ghost_redo_bones_only")
local ghost_difficulty = minetest.settings:get_bool("mobs_ghost_redo_difficulty")

if ghost_daytime_check == nil then
	ghost_daytime_check = false
end

if ghost_bones_only == nil then
	ghost_bones_only = false
end

if ghost_difficulty == nil then
	ghost_difficulty = false
end

-- Mineclone check

local mod_mcl = minetest.get_modpath("mcl_core")

-- Spawn settings (default, bones only, mineclone)

local SPAWNING_CHANCE = 7500
local ACTIVE_OBJECTS = 2
local SPAWNING_NODES = {"group:cracky", "group:crumbly"}

if mod_mcl == true then
	SPAWNING_NODES = {"group:pickaxey", "group:shovely"}
end

if ghost_bones_only == true then
	SPAWNING_NODES = {"bones:bones", "mobs_humans:human_bones"}
	SPAWNING_CHANCE = 7
	ACTIVE_OBJECTS = 1
end

-- Functions

local function is_daytime()

	local time = minetest.get_timeofday() * 24000

	if time >= 4700 and time <= 19250 then return true end
end

local function random_mesh()

	if math.random(2) == 2 then
		return "mobs_ghost_redo_ghost_2.b3d"
	end

	return "mobs_ghost_redo_ghost_1.b3d"
end


-- YAMS-TODO: think of more drops
local function gen_drops(pos)
	local res = {}

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 1, min = 1, max = 2}
		)

		table.insert(res,
			{name = "magic_materials:februm_crystal", chance = 16, min = 1, max = 1}
		)
	end

	return res
end

-- Drops

local DROPS = {{name = (mod_mcl and "mcl_raw_ores:raw_gold" or "default:gold_lump"),
		chance = 100, min = 1, max = 5}}

-- Entity definition

mobs:register_mob("mobs_ghost_redo:ghost", {
	type = "monster",
	hp_min = 12,
	hp_max = 80,
	armor = 100,
	yams_resists = {
		yams_physical = {damage = 50, knockback = 0},
		yams_fire = {damage = 150, knockback = 100},
		yams_mese = {damage = 150, knockback = 100},
		yams_light = {damage = 200, knockback = 100},
		yams_dark = {damage = -100, knockback = 0}
	},
	walk_velocity = 1,
	run_velocity = 2,
	run_velocity_max = 4,
	walk_chance = 25,
	fly = true,
	view_range = 15,
	reach = 2,
	damage = 2,
	damage_max = 30,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 2,
	suffocation = false,
	attack_animals = true,
	group_attack = true,
	attack_type = "dogfight",
	blood_texture = "[fill:1x1:#ffffff88",  -- YAMS-TODO: temporary
	makes_footstep_sound = false,
	sounds = {
		random = "mobs_ghost_redo_ghost_1",
		war_cry = "mobs_ghost_redo_ghost_2",
		attack = "mobs_ghost_redo_ghost_2",
		damage = "mobs_ghost_redo_ghost_hit",
		death = "mobs_ghost_redo_ghost_death"
	},
	drops = gen_drops,
	visual = "mesh",
	visual_size = {x = 1, y = 1},
	collisionbox = {-0.3, -0.5, -0.3, 0.3, 1.5, 0.3},
	textures = {"mobs_ghost_redo_ghost.png"},
	mesh = "mobs_ghost_redo_ghost_1.b3d",
	animation = {
		stand_start = 0, stand_end = 80, stand_speed = 15,
		walk_start = 102, walk_end = 122, walk_speed = 12,
		run_start = 102, run_end = 122, run_speed = 10,
		fly_start = 102, fly_end = 122, fly_speed = 12,
		punch_start = 102, punch_end = 122, punch_speed = 25,
		die_start = 81, die_end = 101, die_speed = 28, die_loop = false
	},
	base_exp = 75,
	max_exp = 4000,

	on_spawn = function(self, pos)

		--[[
		if ghost_difficulty == true then

			self.health = math.random(20, 30)

			self.immune_to = {
				{(mod_mcl and "mcl_tools:sword_iron" or "default:sword_steel"), 6},
				{"default:sword_bronze", 6},
				{(mod_mcl and "mcl_tools:sword_gold" or "default:sword_mese"), 7},
				{"mobs_others:sword_obsidian", 7},
				{(mod_mcl and "mcl_tools:sword_diamond" or "default:sword_diamond"), 8},
				{"moreores:sword_silver", 12},
				{"moreores:sword_mithril", 9},
				{"pigiron:sword_iron", 6},
				{"all"}
			}
		end
		]]--

		--self.spawned = true
		self.mesh = random_mesh()
		--self.counter = 0
		self.object:set_properties({
			--health = self.health,
			--immune_to = self.immune_to,
			--spawned = self.spawned,
			mesh = self.mesh,
			--counter = self.counter,
			physical = false,
			collide_with_objects = false
		})

		return true
	end,

	--[[
	do_custom = function(self, dtime)

		if ghost_daytime_check == true then

			if self.light_damage ~= 0 then

				self.light_damage = 0

				self.object:set_properties({
					light_damage = self.light_damage
				})
			end

			if self.spawned == true then

				if is_daytime() == true then
					self.object:remove()
				else
					self.spawned = false
					self.object:set_properties({
						spawned = self.spawned
					})
				end
			else
				if self.counter < 15.0 then

					self.counter = self.counter + dtime

					self.object:set_properties({
						counter = self.counter
					})
				else

					if is_daytime() == true then
						self.object:remove()
					else
						self.counter = 0

						self.object:set_properties({
							counter = self.counter
						})
					end
				end
			end
		else
			if self.light_damage ~= 2 then

				self.light_damage = 2

				self.object:set_properties({
					light_damage = self.light_damage
				})
			end
		end
	end
	]]--
})

-- Ghost spawn - Check for custom spawn.lua

--[[
local MP = minetest.get_modpath(minetest.get_current_modname()) .. "/"
local input = io.open(MP .. "spawn.lua", "r")

if input then
	input:close() ; input = nil ; dofile(MP .. "spawn.lua")
else
	mobs:spawn({name = "mobs_ghost_redo:ghost",
		nodes = SPAWNING_NODES,
		neighbors = {"air"},
		max_light = 4,
		interval = 60,
		chance = SPAWNING_CHANCE,
		active_object_count = ACTIVE_OBJECTS,
		min_height = -30912,
		day_toggle = false
	})
end
]]--

-- above ground spawn
mobs:spawn({name = "mobs_ghost_redo:ghost",
	nodes = {"default:dirt_with_grass", "default:dirt_with_snow",
		"default:dirt_with_rainforest_litter", "default:dirt_with_coniferous_litter",
		"default:dry_dirt_with_dry_grass", "default:sand", "default:desert_sand",
		"default:silver_sand", "default:snowblock", "default:permafrost_with_stones",
		"ebiomes:dirt_with_grass_med", "ebiomes:dirt_with_grass_steppe_warm",
		"ebiomes:dirt_with_grass_steppe", "ebiomes:dirt_with_grass_steppe_cold",
		"ebiomes:dirt_with_grass_cold", "ebiomes:dirt_with_grass_swamp",
		"ebiomes:dirt_with_grass_warm", "ebiomes:dry_dirt_with_grass_arid",
		"ebiomes:dry_dirt_with_grass_arid_cool", "ebiomes:peat_with_swamp_moss_yellow",
		"ebiomes:dirt_with_japanese_rainforest_litter", "ebiomes:dirt_with_forest_litter",
		"ebiomes:dirt_with_jungle_savanna_grass",
		"ebiomes:dry_dirt_with_humid_savanna_grass"},
	neighbors = {},
	min_light = 0,
	max_light = 4,
	interval = 15,
	chance = 64000,  -- Less likely since it can spawn basically anywhere
	min_height = 0,
	max_height = 8190,
	day_toggle = false
})

-- below ground spawn
mobs:spawn({
	name = "mobs_ghost_redo:ghost",
	nodes = {"default:stone", "default:desert_stone", "default:sandstone",
		"default:sand", "default:desert_sand", "default:silver_sand",
		"default:ice", "caverealms:stone_with_moss",
		"caverealms:stone_with_lichen", "caverealms:stone_with_algae",
		"caverealms:stone_with_salt", "caverealms:hot_cobble",
		"caverealms:thin_ice", "caverealms:glow_obsidian",
		"caverealms:glow_obsidian_2", "caverealms:coal_dust"},
	min_light = 0,
	max_light = 4,
	interval = 15,
	chance = 32000,  -- Less likely than other mobs due to its resistances
	min_height = -19990,
	max_height = -512,  -- There's already too many mobs close to the surface
})

-- Ghost's egg

mobs:register_egg("mobs_ghost_redo:ghost", S("Ghost Spawner"),
	"mobs_ghost_redo_egg_ghost.png", 0)

-- Alias

mobs:alias_mob("mobs:ghost", "mobs_ghost_redo:ghost")


print("[MOD] Mobs Ghost Redo loaded.")
